/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.styles;

import java.util.Iterator;
import java.util.Map;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.DLList;
import com.openexchange.office.filter.odf.SaxContextHandler;

abstract public class NumberStyleBase extends StyleBase {

	private DLList<IElementWriter> content;

	public NumberStyleBase(StyleFamily family, String name, boolean automaticStyle, boolean contentStyle) {
		super(family, name, automaticStyle, contentStyle);
	}

	protected NumberStyleBase(String name, AttributesImpl attributesImpl, boolean defaultStyle, boolean automaticStyle,	boolean contentStyle) {
		super(name, attributesImpl, defaultStyle, automaticStyle, contentStyle);
	}

	final public DLList<IElementWriter> getContent() {
		if(content==null) {
			content = new DLList<IElementWriter>();
		}
		return content;
	}

	@Override
	final public StyleFamily getFamily() {
		return StyleFamily.DATA_STYLE;
	}

	@Override
    public AttributesImpl getAttributes() {
		return attributes;
	}

	public abstract String getFormat(StyleManager styleManager, Map<String, String> additionalStyleProperties, boolean contentAutoStyle);

	public abstract void setFormat(String formatCode, Map<String, String> additionalStyleProperties);

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
		writeAttributes(output);
		final Iterator<IElementWriter> iter = getContent().iterator();
		while(iter.hasNext()) {
			iter.next().writeObject(output);
		}
		writeMapStyleList(output);
		SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());
	}

	@Override
	final protected int _hashCode() {
		int hash = 0;
		if(content!=null&&!content.isEmpty()) {
			final Iterator<IElementWriter> contentIter = content.iterator();
			while(contentIter.hasNext()) {
				hash = hash * 31 + contentIter.next().hashCode();
			}
		}
		return hash;
	}

	@Override
	final protected boolean _equals(StyleBase e) {
		final NumberStyleBase other = (NumberStyleBase)e;
		if(content!=null&&!content.isEmpty()) {
			if(other.content==null||other.content.isEmpty()) {
				return false;
			}
			if(content.size()!=other.content.size()) {
				return false;
			}
			final Iterator<IElementWriter> sourceIter = content.iterator();
			final Iterator<IElementWriter> destIter = other.content.iterator();
			while(sourceIter.hasNext()) {
				if(!sourceIter.next().equals(destIter.next())) {
					return false;
				}
			}
		}
		else if(other.content!=null&&!other.content.isEmpty()) {
			return false;
		}
		return true;
	}

	@Override
	public NumberStyleBase clone() {
		return (NumberStyleBase)_clone();
	}

    static protected String getColorElement(String colorToken) {
        String ret = "";
        if(colorToken.equalsIgnoreCase("RED")) {
            ret = "#ff0000";
        } else if(colorToken.equalsIgnoreCase("BLUE")) {
            ret = "#0000ff";
        } else if(colorToken.equalsIgnoreCase("GREEN")) {
            ret = "#00ff00";
        } else if(colorToken.equalsIgnoreCase("WHITE")) {
            ret = "#ffffff";
        } else if(colorToken.equalsIgnoreCase("MAGENTA")) {
            ret = "#ff00ff";
        } else if(colorToken.equalsIgnoreCase("YELLOW")) {
            ret = "#ffff00";
        } else if(colorToken.equalsIgnoreCase("CYAN")) {
            ret = "#00ffff";
        } else if(colorToken.equalsIgnoreCase("BLACK")) {
            ret = "#000000";
        }
        return ret;
    }
}
