/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum OCValue {

    CHANGE_AUTO_STYLE("changeAutoStyle", "cas"),
    CHANGE_CELLS("changeCells", "cc"),
    CHANGE_CF_RULE("changeCFRule", "ccf"),
    CHANGE_COLUMNS("changeColumns", "ccol"),
    CHANGE_COMMENT("changeComment", "cco"),
    CHANGE_LAYOUT("changeLayout", "cla"),
    CHANGE_MASTER("changeMaster", "cma"),
    CHANGE_NAME("changeName", "cn"),
    CHANGE_ROWS("changeRows", "cro"),
    CHANGE_STYLE_SHEET("changeStyleSheet", "css"),
    CHANGE_TABLE("changeTable", "ct"),
    CHANGE_TABLE_COLUMN("changeTableColumn", "ctc"),
    CHANGE_VALIDATION("changeValidation", "cva"),
    COPY_SHEET("copySheet", "cs"),
    CREATE_ERROR("createError", "ce"),
    DELETE("delete", "d"),
    DELETE_AUTO_STYLE("deleteAutoStyle", "das"),
    DELETE_CF_RULE("deleteCFRule", "dcf"),
    DELETE_CHART_DATA_SERIES("deleteChartDataSeries", "dcd"),
    DELETE_COLUMNS("deleteColumns", "dcol"),
    DELETE_COMMENT("deleteComment", "dco"),
    DELETE_DRAWING("deleteDrawing", "dd"),
    DELETE_HEADER_FOOTER("deleteHeaderFooter", "dhf"),
    DELETE_HYPERLINK("deleteHyperlink", "dhy"),
    DELETE_NAME("deleteName", "dn"),
    DELETE_NUMBER_FORMAT("deleteNumberFormat", "dnf"),
    DELETE_ROWS("deleteRows", "dro"),
    DELETE_SHEET("deleteSheet", "dsh"),
    DELETE_STYLE_SHEET("deleteStyleSheet", "dss"),
    DELETE_TABLE("deleteTable", "dta"),
    DELETE_VALIDATION("deleteValidation", "dva"),
    GROUP("group", "g"),
    INSERT_AUTO_STYLE("insertAutoStyle", "ias"),
    INSERT_BOOKMARK("insertBookmark", "ibm"),
    INSERT_CELLS("insertCells", "ic"),
    INSERT_CF_RULE("insertCFRule", "icr"),
    INSERT_CHART_DATA_SERIES("insertChartDataSeries", "icd"),
    INSERT_COLUMN("insertColumn", "ico"),
    INSERT_COLUMNS("insertColumns", "icol"),
    INSERT_COMMENT("insertComment", "icom"),
    INSERT_COMPLEX_FIELD("insertComplexField", "icf"),
    INSERT_DRAWING("insertDrawing", "id"),
    INSERT_FIELD("insertField", "if"),
    INSERT_FONT_DESCRIPTION("insertFontDescription", "ifd"),
    INSERT_HARD_BREAK("insertHardBreak", "ihb"),
    INSERT_HEADER_FOOTER("insertHeaderFooter", "ihf"),
    INSERT_HYPERLINK("insertHyperlink", "ihl"),
    INSERT_LAYOUT_SLIDE("insertLayoutSlide", "ils"),
    INSERT_LIST_STYLE("insertListStyle", "ili"),
    INSERT_MASTER_SLIDE("insertMasterSlide", "ims"),
    INSERT_NAME("insertName", "in"),
    INSERT_NUMBER_FORMAT("insertNumberFormat", "inf"),
    INSERT_PARAGRAPH("insertParagraph", "ip"),
    INSERT_RANGE("insertRange", "ira"),
    INSERT_ROWS("insertRows", "iro"),
    INSERT_SHEET("insertSheet", "ish"),
    INSERT_SLIDE("insertSlide", "isl"),
    INSERT_STYLE_SHEET("insertStyleSheet", "iss"),
    INSERT_TAB("insertTab", "itb"),
    INSERT_TABLE("insertTable", "ita"),
    INSERT_TEXT("insertText", "it"),
    INSERT_THEME("insertTheme", "ith"),
    INSERT_VALIDATION("insertValidation", "iva"),
    MERGE_CELLS("mergeCells", "mc"),
    MERGE_PARAGRAPH("mergeParagraph", "mp"),
    MERGE_TABLE("mergeTable", "mt"),
    MOVE("move", "mo"),
    MOVE_DRAWING("moveDrawing", "md"),
    MOVE_LAYOUT_SLIDE("moveLayoutSlide", "mls"),
    MOVE_SHEET("moveSheet", "msh"),
    MOVE_SLIDE("moveSlide", "msl"),
    NO_OP("noOp", "no"),
    SET_ATTRIBUTES("setAttributes", "sa"),
    SET_CHART_AXIS_ATTRIBUTES("setChartAxisAttributes", "sca"),
    SET_CHART_DATA_SERIES_ATTRIBUTES("setChartDataSeriesAttributes", "scd"),
    SET_CHART_GRIDLINE_ATTRIBUTES("setChartGridlineAttributes", "scg"),
    SET_CHART_LEGEND_ATTRIBUTES("setChartLegendAttributes", "scl"),
    SET_CHART_TITLE_ATTRIBUTES("setChartTitleAttributes", "sct"),
    SET_DOCUMENT_ATTRIBUTES("setDocumentAttributes", "sda"),
    SET_DRAWING_ATTRIBUTES("setDrawingAttributes", "sdr"),
    SET_SHEET_ATTRIBUTES("setSheetAttributes", "ssa"),
    SET_SHEET_NAME("setSheetName", "ssn"),
    SPLIT_PARAGRAPH("splitParagraph", "sp"),
    SPLIT_TABLE("splitTable", "st"),
    UNGROUP("ungroup", "ug"),
    UNKNOWN_VALUE("unknownValue", "uk"),
    UPDATE_COMPLEX_FIELD("updateComplexField", "ucf"),
    UPDATE_FIELD("updateField", "uf");

    private String value;
    final private String longName;
    final private String shortName; 

    private static Map<String, OCValue> nameToEnumMap = Collections.unmodifiableMap(initializeNameToEnumMap(true));

    private OCValue(String longName, String shortName) {
        this.longName = longName;
        this.shortName = shortName;
        this.value = shortName!=null ? shortName : longName;
    }

    public String value() {
        return value;
    }

    public String value(boolean useLongName) {
        return useLongName ? longName : value;
    }

    public static OCValue fromValue(String val) {
        final OCValue value = nameToEnumMap.get(val);
        if(value==null) {
            return UNKNOWN_VALUE;
        }
        return value;
    }

    private static Map<String, OCValue> initializeNameToEnumMap(boolean useShortName) {
        final Map<String, OCValue> mMap = new HashMap<String, OCValue>();
        for (OCValue s : OCValue.values()) {
            s.value = s.longName;
            if(useShortName && s.shortName!=null) {
                s.value = s.shortName;
            }
            mMap.put(s.value, s);
        }
        return mMap;
    }

    public static void debugOnly(boolean useShortName) {
        nameToEnumMap = Collections.unmodifiableMap(initializeNameToEnumMap(useShortName));
    }
}
