/*
 * Decompiled with CFR 0.152.
 */
package org.json.helpers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.json.helpers.AbstractStringAllocator;

public final class StringAllocator
extends AbstractStringAllocator
implements Serializable {
    private static final long serialVersionUID = -7570175078892044337L;
    private static final Constructor<String> STRING_CONSTRUCTOR;

    static {
        Constructor strConstructor;
        try {
            strConstructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
            strConstructor.setAccessible(true);
        }
        catch (SecurityException e) {
            strConstructor = null;
        }
        catch (NoSuchMethodException e) {
            strConstructor = null;
        }
        STRING_CONSTRUCTOR = strConstructor;
    }

    public StringAllocator() {
        super(16);
    }

    public StringAllocator(int capacity) {
        super(capacity);
    }

    public StringAllocator(String str) {
        super(str.length() + 16);
        this.append(str);
    }

    public StringAllocator(CharSequence seq) {
        this(seq.length() + 16);
        this.append(seq);
    }

    public StringAllocator append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringAllocator append(String str) {
        super.append(str);
        return this;
    }

    private StringAllocator append(StringAllocator sb) {
        if (sb == null) {
            return this.append("null");
        }
        int len = sb.length();
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public StringAllocator append(StringBuffer sb) {
        super.append(sb);
        return this;
    }

    public StringAllocator append(CharSequence s) {
        if (s == null) {
            return this.append("null");
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return this.append((StringBuffer)s);
        }
        if (s instanceof StringAllocator) {
            return this.append((StringAllocator)s);
        }
        return this.append(s, 0, s.length());
    }

    public StringAllocator append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    public StringAllocator append(char[] str) {
        super.append(str);
        return this;
    }

    public StringAllocator append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    public StringAllocator append(boolean b) {
        super.append(b);
        return this;
    }

    public StringAllocator append(char c) {
        super.append(c);
        return this;
    }

    public StringAllocator append(int i) {
        super.append(i);
        return this;
    }

    public StringAllocator append(long lng) {
        super.append(lng);
        return this;
    }

    public StringAllocator append(float f) {
        super.append(f);
        return this;
    }

    public StringAllocator append(double d) {
        super.append(d);
        return this;
    }

    public StringAllocator appendCodePoint(int codePoint) {
        super.appendCodePoint(codePoint);
        return this;
    }

    public StringAllocator delete(int start, int end) {
        super.delete(start, end);
        return this;
    }

    public StringAllocator deleteCharAt(int index) {
        super.deleteCharAt(index);
        return this;
    }

    public StringAllocator replace(int start, int end, String str) {
        super.replace(start, end, str);
        return this;
    }

    public StringAllocator insert(int index, char[] str, int offset, int len) {
        super.insert(index, str, offset, len);
        return this;
    }

    public StringAllocator insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public StringAllocator insert(int offset, String str) {
        super.insert(offset, str);
        return this;
    }

    public StringAllocator insert(int offset, char[] str) {
        super.insert(offset, str);
        return this;
    }

    public StringAllocator insert(int dstOffset, CharSequence s) {
        if (s == null) {
            return this.insert(dstOffset, "null");
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    public StringAllocator insert(int dstOffset, CharSequence s, int start, int end) {
        super.insert(dstOffset, s, start, end);
        return this;
    }

    public StringAllocator insert(int offset, boolean b) {
        super.insert(offset, b);
        return this;
    }

    public StringAllocator insert(int offset, char c) {
        super.insert(offset, c);
        return this;
    }

    public StringAllocator insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public StringAllocator insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public StringAllocator insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public StringAllocator insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return AbstractStringAllocator.indexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return AbstractStringAllocator.lastIndexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public StringAllocator reverse() {
        super.reverse();
        return this;
    }

    public String toString() {
        Constructor<String> stringConstructor = STRING_CONSTRUCTOR;
        if (stringConstructor == null) {
            return new String(this.value, 0, this.count);
        }
        try {
            return stringConstructor.newInstance(0, this.count, this.value);
        }
        catch (Exception e) {
            return new String(this.value, 0, this.count);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.count);
        s.writeObject(this.value);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.count = s.readInt();
        this.value = (char[])s.readObject();
    }
}

