/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rest;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.office.backup.restore.RestoreData;
import com.openexchange.office.backup.restore.RestoreDocument;
import com.openexchange.office.tools.common.MissingParameter;
import com.openexchange.office.tools.error.ErrorCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;

public class SaveAsWithBackupAction extends DocumentRESTAction {

    @SuppressWarnings("deprecation")
	private static final Log LOG = com.openexchange.log.Log.loggerFor(SaveAsWithBackupAction.class);

    /**
     * {@link SaveAsWithBackupAction}
     *
     * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
     */

    // @Action(method = RequestMethod.GET, name = "saveaswithbackup", description = "Request to store a new document based on a backup base document and alternative operations.", parameters = {
    //    @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
    //    @Parameter(name = "file_id", description = "The original file id"),
    //    @Parameter(name = "restore_id", description = "The restore ID of the document received joining the document group."),
    //    @Parameter(name = "target_filename", optional=true, description = "If present the new filename of the requested filestore item to be set."),
    //    @Parameter(name = "target_folder_id", optional=true, description = "If present the folder ID where to write the requested infoitem, otherwise the folder of the source is used or if not possible the"),
    //    @Parameter(name = "target_filename", description = "The initial file name of the new file to be created"),
    //    @Parameter(name = "operations", description = "A JSON array containing the pending operations to be applied to the backup document"),
    //    @Parameter(name = "uid", description = "The unique id of the client application.")
    // }, responseDescription = "Response with timestamp: A JSON object containing the new data of the copied file or error information.")

    /**
     * Initializes a new {@link CopyDocumentAction}.
     * @param services
     */
    public SaveAsWithBackupAction(ServiceLookup servicesDEPRECATED) {
        super(null);
    }

    /* (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData, com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        final String missing = MissingParameter.hasMissing(request, "file_id", "restore_id", "target_folder_id");

        if (null != missing) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("Mandatory parameter " + missing + " is missing");
        }

        final String origFileId = request.getParameter("file_id");
        final String targetFolderId = request.getParameter("target_folder_id");
        final String targetFileName = request.getParameter("target_filename");
        final String clientOperations = request.getParameter("operations");
        final String restoreID = request.getParameter("restore_id");

        JSONObject jsonResult = null;
        try {
            // create JSONArray from the string parameter
            JSONArray operations = null;

            // The client operations property can also be set to JSON "null"
            // therefore we have to check this, too.
            // See #44052
            if (StringUtils.isNotEmpty(clientOperations) && !JSONObject.NULL.equals(clientOperations)) {
                operations = new JSONArray(clientOperations);
            }

            // try to initiate the save as with backup document
            RestoreDocument restoreDocument = new RestoreDocument(null);
            RestoreData result = restoreDocument.saveAsWithBackupDocumentAndOperations(session, origFileId, restoreID, targetFolderId, targetFileName, operations);

            // create json result object from the result of saveAsWithBackupDocumentAndOperations
            jsonResult = result.getErrorCode().getAsJSONResultObject();
            jsonResult.put(RestoreData.KEY_RESTORE_FILENAME, (result.getRestoredFileName() == null) ? JSONObject.NULL : result.getRestoredFileName());
            jsonResult.put(RestoreData.KEY_RESTORE_FILEID, (result.getRestoredFileId() == null) ? JSONObject.NULL : result.getRestoredFileId());
            jsonResult.put(RestoreData.KEY_RESTORE_FOLDERID, (result.getRestoredFolderId() == null) ? JSONObject.NULL : result.getRestoredFolderId());
        } catch (JSONException e) {
            jsonResult = ErrorCode.BACKUPDOCUMENT_CLIENTACTIONS_MALFORMED.getAsJSONResultObject();
			LOG.warn ("Save as with backup failed due to JSONException - restoreId: " + ((restoreID == null) ? "unknown" : restoreID), e);
        }

        return getAjaxRequestResult(jsonResult);
    }

}
