package com.openexchange.office.imagemgr;

import com.openexchange.office.tools.doc.DocumentFormat;


public class ResourceHelper {

    public static String getResourceName(final DocumentFormat docFormat, long uid, final String newExt) throws Exception {
        String resourceName = null;

        switch (docFormat) {
        case DOCX: {
            resourceName = "word/media/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case PPTX: {
            resourceName = "ppt/media/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case XLSX: {
            resourceName = "xl/media/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case ODT: {
            resourceName = "Pictures/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case ODS: {
            resourceName = "Pictures/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }
        case ODP: {
            resourceName = "Pictures/uid" + Long.toHexString(uid) + "." + newExt;
            break;
        }

        case NONE:
        case ODG:
        default: {
            break;
        }
        }

        return resourceName;
    }
}
