/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.tools;

import org.docx4j.IndexedNode;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.P;
import org.docx4j.wml.P.Hyperlink;
import com.google.common.collect.ImmutableSet;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.docx.components.HyperlinkContext;
import com.openexchange.office.filter.ooxml.docx.components.ParagraphComponent;
import com.openexchange.office.filter.ooxml.docx.components.RunDelContext;
import com.openexchange.office.filter.ooxml.docx.components.RunInsContext;
import com.openexchange.office.filter.ooxml.docx.components.RunMoveFromContext;
import com.openexchange.office.filter.ooxml.docx.components.RunMoveToContext;
import com.openexchange.office.filter.ooxml.docx.components.SdtParagraphContext;
import com.openexchange.office.filter.ooxml.docx.components.TextRunContext;
import com.openexchange.office.filter.ooxml.docx.components.TextRun_Base;
import org.docx4j.wml.R;
import org.docx4j.wml.RDBase;
import org.docx4j.wml.RIBase;
import org.docx4j.wml.RunDel;
import org.docx4j.wml.RunIns;
import org.docx4j.wml.RunMoveFrom;
import org.docx4j.wml.RunMoveTo;

public class TextRunStateContext implements ITextRunState {

    final TextRun_Base textRunBase;
    private IndexedNode<Object> paragraphNode = null;
    private IndexedNode<Object> textRunNode = null;
    private IndexedNode<Object> hyperlinkNode = null;
    private IndexedNode<Object> runMoveToNode = null;
    private IndexedNode<Object> runMoveFromNode = null;
    private IndexedNode<Object> runInsNode = null;
    private IndexedNode<Object> runDelNode = null;

    public TextRunStateContext(TextRun_Base textRunBase) {
        this.textRunBase = textRunBase;
        ComponentContext parent = textRunBase;
        do {
            parent = parent.getParentContext();
            if(parent instanceof TextRunContext) {
                textRunNode = parent.getNode();
            }
            else if(parent instanceof HyperlinkContext) {
                hyperlinkNode = parent.getNode();
            }
            else if(parent instanceof RunMoveToContext) {
                runMoveToNode = parent.getNode();
            }
            else if(parent instanceof RunMoveFromContext) {
                runMoveFromNode = parent.getNode();
            }
            else if(parent instanceof RunInsContext) {
                runInsNode = parent.getNode();
            }
            else if(parent instanceof RunDelContext) {
                runDelNode = parent.getNode();
            }
        }
        while(!(parent instanceof ParagraphComponent));
        paragraphNode = ((ParagraphComponent)parent).getNode();
    }

    @Override
    public P getParagraph() {
        return paragraphNode!=null ? (P)paragraphNode.getData() : null;
    }

    @Override
    public Hyperlink getHyperlink() {
        return hyperlinkNode!=null ? (P.Hyperlink)hyperlinkNode.getData() : null;
    }

    @Override
    public R getTextRun() {
        return (R)textRunNode.getData();
    }

    @Override
    public boolean hasChangeTracking() {
        return runInsNode!=null||runDelNode!=null||runMoveToNode!=null||runMoveFromNode!=null;
    }

    @Override
    public Hyperlink getHyperlink(boolean forceCreate) {
        getHyperlinkNode(forceCreate);
        return hyperlinkNode!=null ? (P.Hyperlink)hyperlinkNode.getData() : null;
    }

    public IndexedNode<Object> getHyperlinkNode(boolean forceCreate) {
        if(hyperlinkNode==null&&forceCreate) {
            hyperlinkNode = new IndexedNode<Object>(Context.getWmlObjectFactory().createPHyperlink());
            textRunBase.insertContext(new HyperlinkContext(textRunBase.getOperationDocument(), hyperlinkNode), hyperlinkParentContextList);
        }
        return hyperlinkNode;
    }

    @Override
    public void removeHyperlink() {
        if(hyperlinkNode!=null) {
            textRunBase.removeContext(HyperlinkContext.class);
            hyperlinkNode = null;
        }
    }

    static final private ImmutableSet<Class<?>> hyperlinkParentContextList = ImmutableSet.<Class<?>> builder()
        .add(SdtParagraphContext.class)
        .build();

    @Override
    public RIBase getRunIns(boolean forceCreate) {
        getRunInsNode(forceCreate);
        return runInsNode!=null ? (RunIns)runInsNode.getData() : runMoveToNode!=null ? (RunMoveTo)runMoveToNode.getData() : null;
    }

    public IndexedNode<Object> getRunInsNode(boolean forceCreate) {
        if(runInsNode==null&&runMoveToNode==null&&forceCreate) {
            runInsNode = new IndexedNode<Object>(Context.getWmlObjectFactory().createRunIns());
            textRunBase.insertContext(new RunInsContext(textRunBase.getOperationDocument(), runInsNode), runInsParentContextList);
        }
        return runInsNode!=null ? runInsNode : runMoveToNode;
    }

    @Override
    public void removeRunIns() {
        if(runInsNode!=null) {
            textRunBase.removeContext(RunInsContext.class);
            runInsNode = null;
        }
        if(runMoveToNode!=null) {
            textRunBase.removeContext(RunMoveToContext.class);
            runMoveToNode = null;
        }
    }

    static final private ImmutableSet<Class<?>> runInsParentContextList = ImmutableSet.<Class<?>> builder()
        .add(SdtParagraphContext.class)
        .add(HyperlinkContext.class)
        .build();

    @Override
    public RDBase getRunDel(boolean forceCreate) {
        getRunDelNode(forceCreate);
        return runDelNode!=null ? (RunDel)runDelNode.getData() : runMoveFromNode!=null ? (RunMoveFrom)runMoveFromNode.getData() : null;
    }

    public IndexedNode<Object> getRunDelNode(boolean forceCreate) {
        if(runDelNode==null&&runMoveFromNode==null&&forceCreate) {
            runDelNode = new IndexedNode<Object>(Context.getWmlObjectFactory().createRunDel());
            textRunBase.insertContext(new RunDelContext(textRunBase.getOperationDocument(), runDelNode), runDelParentContextList);
        }
        return runDelNode!=null ? runDelNode : runMoveFromNode;
    }

    @Override
    public void removeRunDel() {
        if(runDelNode!=null) {
            textRunBase.removeContext(RunDelContext.class);
            runDelNode = null;
        }
        if(runMoveFromNode!=null) {
            textRunBase.removeContext(RunMoveFromContext.class);
            runMoveFromNode = null;
        }
    }

    static final private ImmutableSet<Class<?>> runDelParentContextList = ImmutableSet.<Class<?>> builder()
        .add(SdtParagraphContext.class)
        .add(HyperlinkContext.class)
        .add(RunMoveToContext.class)
        .add(RunMoveFromContext.class)
        .add(RunInsContext.class)
        .build();

    public void setTextRunNode(IndexedNode<Object> textRunNode) {
        this.textRunNode = textRunNode;
    }

    public void setHyperlinkNode(IndexedNode<Object> hyperlinkNode) {
        this.hyperlinkNode = hyperlinkNode;
    }

    public void setRunMoveToNode(IndexedNode<Object> runMoveToNode) {
        this.runMoveToNode = runMoveToNode;
    }

    public void setRunMoveFromNode(IndexedNode<Object> runMoveFromNode) {
        this.runMoveFromNode = runMoveFromNode;
    }

    public void setRunInsNode(IndexedNode<Object> runInsNode) {
        this.runInsNode = runInsNode;
    }

    public void setRunDelNode(IndexedNode<Object> runDelNode) {
        this.runDelNode = runDelNode;
    }
}
