/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom.chart;

import org.xml.sax.Attributes;
import com.openexchange.office.filter.core.chart.AttributeSet;
import com.openexchange.office.filter.core.chart.ChartAxis;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.DOMBuilder;
import com.openexchange.office.filter.odf.ElementNS;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class ChartAxisHandler extends DOMBuilder {

    private final ChartContentHandler parentContext;
    private final ElementNS axisEl;

    public ChartAxisHandler(ChartContentHandler parentContext, ElementNS axisEl) {
        super(axisEl, parentContext);
        this.parentContext = parentContext;
        this.axisEl = axisEl;
    }

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
        OdfOperationDoc.abortOnLowMemory(getFileDom());
        AttributesImpl attrs = new AttributesImpl(attributes);
        ChartAxis axis = (ChartAxis) axisEl.getUserData(ChartContent.USERDATA);
        String styleName = attrs.getValue(ChartContent.ODF_STYLE);

        switch (qName) {
            case "chart:grid":
                if ("major".equals(attrs.getValue("chart:class"))) {
                    ElementNS gridEl = parentContext.getChart().addGrid(axisEl, styleName);
                    gridEl.addAttributes(attributes);
                }
                return this;
            case "chart:title":
                ElementNS titleEl = parentContext.getChart().addTitle(axisEl, styleName);
                titleEl.addAttributes(attributes);

                AttributeSet title = (AttributeSet) titleEl.getUserData(ChartContent.USERDATA);
                title.setAttributes(parentContext.getChart().getStyleAttrs(styleName));

                return new ChartTitleHandler(parentContext, axis.getAxis(), titleEl);
            case "chart:categories":
                return super.startElement(attributes, uri, localName, qName);
            default:
                return this;
        }
    }

}
