/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

require('../lib/define')('baseobject_perf', [
    'perf!baseobject/baseobject1',
    'perf!baseobject/baseobject2',
    'perf!baseobject/timermixin',
    'io.ox/office/tk/object/baseobject'
], function (BaseObject1, BaseObject2, TimerMixin, BaseObject) {

    'use strict';

    var LogTable = require('../lib/logtable');

    // ========================================================================

    function runTest(func, N) {
        var t0 = Date.now();
        for (var i = 0; i < N; i += 1) {
            func();
        }
        var t1 = Date.now();
        return Math.round((t1 - t0) / N * 1e6);
    }

    function constructTest(Class, N) {
        return runTest(function () {
            /* eslint no-new: 0 */ new Class('w-0');
        }, N);
    }

    function destructTest(Class, N) {
        return runTest(function () {
            var obj = new Class('w-0');
            obj.destroy();
        }, N);
    }

    function completeTest(msg, Class, N) {
        var t1 = constructTest(Class, N);
        var t2 = destructTest(Class, N / 2);
        table.row(msg, t1, t2 - t1);
    }

    var TimerObject1 = BaseObject1.extend({ constructor: function (windowId) {
        BaseObject1.call(this, windowId);
        TimerMixin.call(this);
    } });

    console.log('');
    var table = new LogTable().col(35, true).col(10, true).col(10, true);
    table.head('', 'construct', 'destroy');
    table.sep();
    completeTest('BaseObject (old)', BaseObject1, 1e5);
    completeTest('BaseObject+TimerMixin (old)', TimerObject1, 1e5);
    table.sep();
    completeTest('BaseObject (new)', BaseObject2, 1e6);
    completeTest('BaseObject+TimerMixin (new)', BaseObject, 1e6);
    table.sep();
});
