/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/tk/dialog/messagedialog', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/dialog/basedialog'
], function (Utils, BaseDialog) {

    'use strict';

    // class MessageDialog ====================================================

    /**
     * Creates a simple dialog with a message text and an OK button.
     *
     * @constructor
     *
     * @extends BaseDialog
     *
     * @param {String|Object} windowId
     *  The identifier of the root window of the context application that is
     *  creating the dialog, or an object with a method getWindowId() that
     *  returns such a window identifier. Used for debugging and logging of
     *  running timers in automated test environments.
     *
     * @param {String} message
     *  The message text shown in the dialog body element.
     *
     * @param {Object} [initOptions]
     *  Optional parameters that control the appearance and behavior of the
     *  dialog. Supports all options also supported by the base class
     *  BaseDialog. The option "cancelLabel" will be ignored (the Cancel
     *  button of the dialog will always be hidden).
     */
    var MessageDialog = BaseDialog.extend(function (windowId, message, initOptions) {

        // base constructor
        BaseDialog.call(this, windowId, _.extend({ width: 400 }, initOptions));

        // create a <label> element with the message text
        this.append($('<label>').text(message));

        // remove the Cancel button
        this.getCancelButton().hide();

    }); // class MessageDialog

    // exports ================================================================

    return MessageDialog;

});
