/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define('io.ox/office/presentation/view/popup/presentationcontextmenu', [
    'io.ox/office/tk/utils',
    'io.ox/office/textframework/view/popup/universalcontextmenu',
    'io.ox/office/presentation/view/controls',
    'gettext!io.ox/office/presentation/main'
], function (Utils, UniversalContextMenu, Controls, gt) {

    'use strict';

    // convenience shortcuts
    var Button = Controls.Button;

    // class PresentationContextMenu ==========================================

    /**
     * A context menu specific for Presentation app.
     *
     * @constructor
     *
     * @extends UniversalContextMenu
     */
    function PresentationContextMenu(docView, initOptions) {

        // self reference
        var self = this;

        // document model
        var docModel = docView.getDocModel();

        // base constructor ---------------------------------------------------

        UniversalContextMenu.call(this, docView, Utils.extendOptions({
            delay: Utils.getNumberOption(initOptions, 'delay', 0)
        }, initOptions));

        // public methods ----------------------------------------------------

        this.prepareSlideMenu = function () {
            self.addGroup('layoutslidepicker/changelayout', new Controls.ChangeLayoutSlidePicker(docView, {
                // overwrites
                tooltip: null,
                label: gt('Change layout'),
                icon: 'fa-chevron-right',

                // specialized additional parameters
                iconPos: 'trailing',
                caret: false,
                anchorBorder: 'right bottom top left',

                // speicial handling for odf layout slides
                isOdfLayout: docView.getApp().isODF()
            }))
                .addGroup('slide/setbackground', new Button(docView, { label: gt('Set slide background'), tooltip: gt('Format slide background') }))
                .addSeparator()
                .addGroup('document/present', new Button(docView, { label: gt('Present'), tooltip: gt('Start the Presenter')  }));
        };

        /**
         * Overwrites getXY method from UniversalContextMenu - for presentation is hack for IE not needed.
         * @param {jQuery.Event} event
         *  Click event
         */
        this.getXY = function (event) {
            if (docModel.isDrawingSelected()) {
                return {
                    pageX: event.pageX,
                    pageY: event.pageY
                };
            } else {
                return (event.sourceEvent) ? {
                    pageX: event.sourceEvent.pageX,
                    pageY: event.sourceEvent.pageY
                } : null;
            }
        };

        // destroy all class members
        this.registerDestructor(function () {
            self = docView = null;
        });

    } // class PresentationContextMenu

    // exports ================================================================

    // derive this class from class PresentationContextMenu
    return UniversalContextMenu.extend({ constructor: PresentationContextMenu });

});
