/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Mario Schroeder <mario.schroeder@open-xchange.com>
 */

define('io.ox/office/editframework/view/popup/editcontextmenu', [
    'io.ox/office/baseframework/view/popup/contextmenu',
    'io.ox/office/editframework/view/editcontrols',
    'io.ox/office/editframework/view/editlabels'
], function (ContextMenu, Controls, Labels) {

    'use strict';

    // convenience shortcuts
    var Button = Controls.Button;

    // class EditContextMenu ==================================================

    /**
     * Base class for context menus with helper methods that add generic edit
     * commands into the context menu.
     *
     * @constructor
     *
     * @extends ContextMenu
     */
    var EditContextMenu = ContextMenu.extend({ constructor: function (docView, sourceNode, initOptions) {

        // base constructor ---------------------------------------------------

        ContextMenu.call(this, docView, sourceNode, initOptions);

        // public methods -----------------------------------------------------

        /**
         * Adds entries for clipboard commands "Cut", "Copy", and "Paste" to
         * this context menu.
         *
         * @returns {EditContextMenu}
         *  A reference to this instance.
         */
        this.addClipboardEntries = function () {

            // iOS and Android devices provide a native context menu with cut, copy and paste.
            if (_.device('iOS || Android')) { return; }

            this.addGroup('document/cut',   new Button(docView, { icon: 'fa-cut',   label: Labels.CUT_LABEL,   tooltip: Labels.CUT_TOOLTIP }));
            this.addGroup('document/copy',  new Button(docView, { icon: 'fa-copy',  label: Labels.COPY_LABEL,  tooltip: Labels.COPY_TOOLTIP }));
            this.addGroup('document/paste', new Button(docView, { icon: 'fa-paste', label: Labels.PASTE_LABEL, tooltip: Labels.PASTE_TOOLTIP }));

            return this;
        };

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = null;
        });

    } }); // class EditContextMenu

    // exports ================================================================

    return EditContextMenu;

});
