/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/groupmodel', [
    'io.ox/office/drawinglayer/model/drawingmodel'
], function (DrawingModel) {

    'use strict';

    // class GroupModel =======================================================

    /**
     * The model of a group object containing an embedded drawing collection
     * with child drawing objects.
     *
     * @constructor
     *
     * @extends DrawingModel
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var GroupModel = DrawingModel.extend({ constructor: function (parentCollection, initAttributes) {

        // base constructor ---------------------------------------------------

        DrawingModel.call(this, parentCollection, 'group', initAttributes, { children: true, rotatable: true });

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            parentCollection = initAttributes = null;
        });

    } }); // class GroupModel

    // exports ================================================================

    return GroupModel;

});
