module.exports = {

    // stop looking for ESLint configuration in parent directories
    root: true,

    env: {
        amd: true   // defines require() and define() as global variables as per the amd spec
    },

    globals: {

        // browser environment
        navigator: false,
        screen: false,
        window: false,
        document: false,
        console: false,
        localStorage: false,

        // browser classes
        HTMLElement: false,

        // 3rd-party libraries
        $: false,
        _: false,
        Backbone: false,
        moment: false,

        // AppSuite globals
        ox: false
    },

    rules: {

        // RULE LEVELS ========================================================
        //
        // Rule level 0: Rule is turned off.
        // Rule level 1: Rule produces a warning, but does not exit.
        // Rule level 2: Rule produces an error, and exits.
        //
        // http://eslint.org/docs/user-guide/configuring#configuring-rules

        // POSSIBLE ERRORS ====================================================
        //
        // The following rules point out areas where you might have made mistakes.
        //
        // http://eslint.org/docs/rules/index.html#possible-errors

        // disallow assignment in conditional expressions
        'no-cond-assign': [2, 'except-parens'],

        // disallow use of console in the node environment
        'no-console': 1,

        // disallow use of constant expressions in conditions
        'no-constant-condition': 0,

        // disallow control characters in regular expressions
        'no-control-regex': 0,

        // disallow use of debugger
        'no-debugger': 1,

        // disallow duplicate arguments in functions
        'no-dupe-args': 2,

        // disallow duplicate keys when creating object literals
        'no-dupe-keys': 2,

        // disallow a duplicate case label.
        'no-duplicate-case': 2,

        // disallow empty statements
        'no-empty': 0,

        // disallow the use of empty character classes in regular expressions
        'no-empty-character-class': 2,

        // disallow assigning to the exception in a catch block
        'no-ex-assign': 2,

        // disallow double-negation boolean casts in a boolean context
        'no-extra-boolean-cast': 2,

        // disallow unnecessary parentheses
        'no-extra-parens': [2, 'functions'],

        // disallow unnecessary semicolons (fixable)
        'no-extra-semi': 2,

        // disallow overwriting functions written as function declarations
        'no-func-assign': 2,

        // disallow function or variable declarations in nested blocks
        'no-inner-declarations': 2,

        // disallow invalid regular expression strings in the RegExp constructor
        'no-invalid-regexp': 2,

        // disallow irregular whitespace outside of strings and comments
        'no-irregular-whitespace': 2,

        // disallow the use of object properties of the global object (Math and JSON) as functions
        'no-obj-calls': 2,

        // disallow use of Object.prototypes builtins directly
        'no-prototype-builtins': 2,

        // disallow multiple spaces in a regular expression literal
        'no-regex-spaces': 2,

        // disallow sparse arrays
        'no-sparse-arrays': 2,

        // disallow template literal placeholder syntax in regular strings
        'no-template-curly-in-string': 2,

        // Avoid code that looks like two expressions but is actually one
        'no-unexpected-multiline': 2,

        // disallow unreachable statements after a return, throw, continue, or break statement
        'no-unreachable': 2,

        // disallow control flow statements in finally blocks
        'no-unsafe-finally': 2,

        // disallow negating the left operand of relational operators
        'no-unsafe-negation': 2,

        // disallow comparisons with the value NaN
        'use-isnan': 2,

        // Ensure JSDoc comments are valid
        'valid-jsdoc': 0,

        // Ensure that the results of typeof are compared against a valid string
        'valid-typeof': 2,

        // BEST PRACTICES =====================================================
        //
        // These are rules designed to prevent you from making mistakes. They
        // either prescribe a better way of doing something or help you avoid
        // footguns.
        //
        // http://eslint.org/docs/rules/index.html#best-practices

        // enforces getter/setter pairs in objects
        'accessor-pairs': 2,

        // enforces return statements in callbacks of array's methods
        'array-callback-return': 0,

        // treat var statements as if they were block scoped
        'block-scoped-var': 2,

        // enforce that class methods utilize this
        'class-methods-use-this': 2,

        // specify the maximum cyclomatic complexity allowed in a program
        'complexity': [0, 11],

        // require return statements to either always or never specify values
        'consistent-return': 0,

        // specify curly brace conventions for all control statements
        'curly': 2,

        // require default case in switch statements
        'default-case': 0,

        // enforces consistent newlines before or after dots
        'dot-location': 0,

        // encourages use of dot notation whenever possible
        'dot-notation': [2, { allowKeywords: true }],

        // require the use of === and !==
        'eqeqeq': 2,

        // make sure for-in loops have an if statement
        'guard-for-in': 0,

        // disallow the use of alert, confirm, and prompt
        'no-alert': 1,

        // disallow use of arguments.caller or arguments.callee
        'no-caller': 2,

        // disallow lexical declarations in case clauses
        'no-case-declarations': 2,

        // disallow division operators explicitly at beginning of regular expression
        'no-div-regex': 2,

        // disallow else after a return in an if
        'no-else-return': 0,

        // disallow empty functions
        'no-empty-function': 0,

        // disallow use of empty destructuring patterns
        'no-empty-pattern': 2,

        // disallow comparisons to null without a type-checking operator
        'no-eq-null': 2,

        // disallow use of eval()
        'no-eval': 2,

        // disallow adding to native types
        'no-extend-native': 2,

        // disallow unnecessary function binding
        'no-extra-bind': 2,

        // disallow unnecessary labels
        'no-extra-label': 2,

        // disallow fallthrough of case statements
        'no-fallthrough': 2,

        // disallow the use of leading or trailing decimal points in numeric literals
        'no-floating-decimal': 2,

        // disallow assignment to native objects or read-only global variables
        'no-global-assign': 2,

        // disallow the type conversions with shorter notations
        'no-implicit-coercion': 0,

        // disallow var and named functions in global scope
        'no-implicit-globals': 2,

        // disallow use of eval()-like methods
        'no-implied-eval': 2,

        // disallow this keywords outside of classes or class-like objects
        'no-invalid-this': 0,

        // disallow usage of __iterator__ property
        'no-iterator': 2,

        // disallow use of labeled statements
        'no-labels': 2,

        // disallow unnecessary nested blocks
        'no-lone-blocks': 2,

        // disallow creation of functions within loops
        'no-loop-func': 2,

        // disallow the use of magic numbers
        'no-magic-numbers': 0,

        // disallow use of multiple spaces
        'no-multi-spaces': 0,

        // disallow use of multiline strings
        'no-multi-str': 2,

        // disallow use of new operator when not part of the assignment or comparison
        'no-new': 2,

        // disallow use of new operator for Function object
        'no-new-func': 2,

        // disallows creating new instances of String, Number, and Boolean
        'no-new-wrappers': 2,

        // disallow use of (old style) octal literals
        'no-octal': 2,

        // disallow use of octal escape sequences in string literals
        'no-octal-escape': 2,

        // disallow reassignment of function parameters
        'no-param-reassign': 0,

        // disallow usage of __proto__ property
        'no-proto': 2,

        // disallow declaring the same variable more then once
        'no-redeclare': 2,

        // disallow certain object properties
        'no-restricted-properties': [2, {
            'property': 'DRAWING_INSERT',
            'message': 'Please use INSERT_DRAWING.'
        }],

        // disallow use of assignment in return statement
        'no-return-assign': [2, 'except-parens'],

        // disallow use of `javascript:` urls.
        'no-script-url': 2,

        // disallow self assignment
        'no-self-assign': 2,

        // disallow comparisons where both sides are exactly the same
        'no-self-compare': 2,

        // disallow use of comma operator
        'no-sequences': 2,

        // restrict what can be thrown as an exception
        'no-throw-literal': 2,

        // disallow unmodified conditions of loops
        'no-unmodified-loop-condition': 0, // disabled: https://github.com/eslint/eslint/issues/6280

        // disallow usage of expressions in statement position
        'no-unused-expressions': 2,

        // disallow unused labels
        'no-unused-labels': 2,

        // disallow unnecessary .call() and .apply()
        'no-useless-call': 2,

        // disallow unnecessary concatenation of literals or template literals
        'no-useless-concat': 2,

        // disallow unnecessary escape characters
        'no-useless-escape': 2,

        // disallow redundant return statements
        // TODO: disabled due to https://github.com/eslint/eslint/issues/7477
        'no-useless-return': 0,

        // disallow use of void operator
        'no-void': 2,

        // disallow usage of configurable warning terms in comments: e.g. todo
        'no-warning-comments': [0, { 'terms': ['todo', 'fixme', 'xxx'], 'location': 'start' }],

        // disallow use of the with statement
        'no-with': 2,

        // require use of the second argument for parseInt()
        'radix': 2,

        // requires to declare all vars on top of their containing scope
        'vars-on-top': 0,

        // require immediate function invocation to be wrapped in parentheses
        'wrap-iife': [2, 'outside'],

        // require or disallow Yoda conditions
        'yoda': 0,

        // STRICT MODE ========================================================
        //
        // These rules relate to using strict mode.
        //
        // http://eslint.org/docs/rules/index.html#strict-mode

        // controls location of Use Strict Directives
        'strict': [2, 'function'],

        // VARIABLES ==========================================================
        //
        // These rules have to do with variable declarations.
        //
        // http://eslint.org/docs/rules/index.html#variables

        // enforce or disallow variable initializations at definition
        'init-declarations': 0,

        // disallow the catch clause parameter name being the same as a variable in the outer scope
        'no-catch-shadow': 2,

        // disallow deletion of variables
        'no-delete-var': 2,

        // disallow labels that share a name with a variable
        'no-label-var': 2,

        // disallow specific global variables
        'no-restricted-globals': 2,

        // disallow declaration of variables already declared in the outer scope
        'no-shadow': 0,

        // disallow shadowing of names such as arguments
        'no-shadow-restricted-names': 2,

        // disallow use of undeclared variables unless mentioned in a 'globals'
        'no-undef': [2, { typeof: true }],

        // disallow use of undefined when initializing variables
        'no-undef-init': 2,

        // disallow use of undefined variable
        'no-undefined': 0,

        // disallow declaration of variables that are not used in the code
        'no-unused-vars': 2,

        // disallow use of variables before they are defined
        'no-use-before-define': 0,

        // STYLE ==============================================================
        //
        // These rules are purely matters of style and are quite subjective.
        //
        // http://eslint.org/docs/rules/index.html#stylistic-issues

        // disallow or enforce spacing inside array brackets
        'array-bracket-spacing': [2, 'never'],

        // disallow or enforce spaces inside of single line blocks
        'block-spacing': [2, 'always'],

        // enforce one true brace style
        'brace-style': [2, '1tbs', { allowSingleLine: true }],

        // require camel case names
        'camelcase': 0,

        // disallow dangling commas
        'comma-dangle': [2, 'never'],

        // enforce spacing before and after comma
        'comma-spacing': [2, { before: false, after: true }],

        // enforce one true comma style
        'comma-style': [2, 'last'],

        // require or disallow padding inside computed properties
        'computed-property-spacing': [2, 'never'],

        // enforces consistent naming when capturing the current execution context
        'consistent-this': 0,

        // enforce newline at the end of file, with no multiple empty lines
        'eol-last': 2,

        // require or disallow spacing between function identifiers and their invocations
        'func-call-spacing': [2, 'never'],

        // require function expressions to have a name
        'func-names': 0,

        // enforces use of function declarations or expressions
        'func-style': 0,

        // disallow specified identifiers
        'id-blacklist': [2/*, ''*/],

        // this option enforces minimum and maximum identifier lengths (variable names, property names etc.)
        'id-length': 0,

        // require identifiers to match the provided regular expression
        'id-match': 0,

        // this option sets a specific tab width for your code
        'indent': "off",

        // compatibility 3.x
        "indent-legacy": [2, 4, { SwitchCase: 1 }],

        // specify whether double or single quotes should be used in JSX attributes
        'jsx-quotes': 2,

        // enforces spacing between keys and values in object literal properties
        'key-spacing': [2, { beforeColon: false, afterColon: true, mode: 'minimum' }],

        // enforces spacing between keys and values in object literal properties
        'keyword-spacing': 2,

        // disallow mixed 'LF' and 'CRLF' as linebreaks
        'linebreak-style': [2, 'unix'],

        // enforces empty lines around comments
        'lines-around-comment': 0,

        // require or disallow newlines around directives
        'lines-around-directive': 2,

        // specify the maximum depth that blocks can be nested
        'max-depth': 0,

        // specify the maximum length of a line in your program
        'max-len': 0,

        // enforce a maximum file length
        'max-lines': 0,

        // specify the maximum depth callbacks can be nested
        'max-nested-callbacks': 0,

        // limits the number of parameters that can be used in the function declaration.
        'max-params': 0,

        // specify the maximum number of statement allowed in a function
        'max-statements': 0,

        // enforce a maximum number of statements allowed per line
        'max-statements-per-line': 0,

        // enforce or disallow newlines between operands of ternary expressions
        'multiline-ternary': 0,

        // require a capital letter for constructors
        'new-cap': [2, { capIsNew: true, newIsCap: true, properties: true, capIsNewExceptions: ['$.Deferred', 'Baton'] }],

        // disallow the omission of parentheses when invoking a constructor with no arguments
        'new-parens': 2,

        // allow/disallow an empty newline after var statement
        'newline-after-var': 0,

        // require an empty line before return statements
        'newline-before-return': 0,

        // require a newline after each call in a method chain
        'newline-per-chained-call': 0,

        // disallow use of the Array constructor
        'no-array-constructor': 2,

        // disallow use of bitwise operators
        'no-bitwise': 0,

        // disallow use of the continue statement
        'no-continue': 0,

        // disallow comments inline after code
        'no-inline-comments': 0,

        // disallow if as the only statement in an else block
        'no-lonely-if': 0,

        // disallow mixes of different operators
        'no-mixed-operators': [2, {
            'groups': [
                // allow to mix arithmethic operators
                //['+', '-', '*', '/', '%', '**'],
                ['&', '|', '^', '~', '<<', '>>', '>>>'],
                ['==', '!=', '===', '!==', '>', '>=', '<', '<='],
                ['&&', '||'],
                ['in', 'instanceof']
            ],
            'allowSamePrecedence': true
        }],

        // disallow mixed spaces and tabs for indentation
        'no-mixed-spaces-and-tabs': 2,

        // disallow multiple empty lines
        'no-multiple-empty-lines': [2, { max: 1 }],

        // disallow negated conditions
        'no-negated-condition': 0,

        // disallow nested ternary expressions
        'no-nested-ternary': 0,

        // disallow use of the Object constructor
        'no-new-object': 2,

        // disallow use of unary operators, ++ and --
        'no-plusplus': 0,

        // disallow use of certain syntax in code
        'no-restricted-syntax': 0,

        // disallow tabs in file
        'no-tabs': 2,

        // disallow the use of ternary operators
        'no-ternary': 0,

        // disallow trailing whitespace at the end of lines
        'no-trailing-spaces': [2, { skipBlankLines: false }],

        // disallow dangling underscores in identifiers
        'no-underscore-dangle': 0,

        // disallow the use of Boolean literals in conditional expressions
        'no-unneeded-ternary': [2, { defaultAssignment: true }],

        // disallow whitespace before properties
        'no-whitespace-before-property': 2,

        // enforce consistent line breaks inside braces
        'object-curly-newline': 0,

        // require or disallow padding inside curly braces
        'object-curly-spacing': [2, 'always', { objectsInObjects: true, arraysInObjects: true }],

        // enforce placing object properties on separate lines
        'object-property-newline': 0,

        // allow just one var statement per function
        'one-var': 0,

        // require or disallow an newline around variable declarations
        'one-var-declaration-per-line': 0,

        // require assignment operator shorthand where possible or prohibit it entirely
        'operator-assignment': 1,

        // enforce operators to be placed before or after line breaks
        'operator-linebreak': 0,

        // enforce padding within blocks
        'padded-blocks': 0,

        // require quotes around object literal property names
        'quote-props': [2, 'as-needed'],

        // specify whether double or single quotes should be used
        'quotes': [2, 'single', 'avoid-escape'],

        // Require JSDoc comment
        'require-jsdoc': 0,

        // require or disallow use of semicolons instead of ASI
        'semi': [2, 'always'],

        // enforce spacing before and after semicolons
        'semi-spacing': [2, { before: false, after: true }],

        // require object keys to be sorted
        'sort-keys': 0,

        // sort variables within the same declaration block
        'sort-vars': 0,

        // require or disallow space before blocks
        'space-before-blocks': 2,

        // require or disallow space before function opening parenthesis
        'space-before-function-paren': [2, { anonymous: 'always', named: 'never' }],

        // require or disallow spaces inside parentheses
        'space-in-parens': [2, 'never'],

        // require spaces around operators
        'space-infix-ops': 2,

        // Require or disallow spaces before/after unary operators
        'space-unary-ops': 2,

        // require or disallow a space immediately following the // or /* in a comment
        'spaced-comment': 0,

        // require or disallow the Unicode Byte Order Mark (BOM)
        'unicode-bom': [2, "never"],

        // require regex literals to be wrapped in parentheses
        'wrap-regex': 0
    }
};
