/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define([
    'io.ox/office/textframework/utils/textutils'
], function (TextUtils) {

    'use strict';

    // static class TextUtils =================================================

    describe('Text module TextUtils', function () {

        it('should exist', function () {
            expect(TextUtils).to.be.an('object');
        });

        // static methods -----------------------------------------------------

        describe('method "indexOfValuesInsideTextSpan"', function () {
            it('should exist', function () {
                expect(TextUtils).itself.to.respondTo('indexOfValuesInsideTextSpan');
            });
            it('should find the correct index in forward direction', function () {
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 0, [' ', 'W', 'd'])).to.equal(5);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 5, [' ', 'W', 'd'])).to.equal(5);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 0, [' ', 'H', 'W', 'd'])).to.equal(0);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 2, [' ', 'H', 'W', 'd'])).to.equal(5);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 6, [' ', 'H', 'W', 'd'])).to.equal(6);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 7, [' ', 'H', 'W', 'd'])).to.equal(10);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 10, [' ', 'H', 'W', 'd'])).to.equal(10);
            });
            it('should find the correct index in backward direction', function () {
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 8, [' ', 'H', 'W', 'd'], { reverse: true })).to.equal(6);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 5, [' ', 'H', 'W', 'd'], { reverse: true })).to.equal(5);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 4, [' ', 'H', 'W', 'd'], { reverse: true })).to.equal(0);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 8, [' ', 'H', 'W', 'd'], { reverse: true })).to.equal(6);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 10, [' ', 'H', 'W', 'd'], { reverse: true })).to.equal(10);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 20, [' ', 'H', 'W', 'd'], { reverse: true })).to.equal(10);
            });
            it('should find no valid index in forward direction', function () {
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 8, [' ', 'H', 'W'])).to.equal(-1);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 20, [' ', 'H', 'W'])).to.equal(-1);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 0, ['A', 'B', 'C', 'h', 'w'])).to.equal(-1);
            });
            it('should find no valid index in backward direction', function () {
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 4, [' ', 'W'], { reverse: true })).to.equal(-1);
                expect(TextUtils.indexOfValuesInsideTextSpan('Hello World', 10, ['A', 'B', 'C', 'h', 'w'], { reverse: true })).to.equal(-1);
            });
        });
    });

    // ========================================================================
});
