/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/portal/mainhelper'
], function (MainHelper) {

    'use strict';

    // static class PortalUtils ===============================================

    describe('Portal module MainHelper', function () {

        it('should exist', function () {
            expect(MainHelper).to.be.an('object');
        });

        it('should provide "createLauncher"-method', function () {
            expect(MainHelper).to.respondTo('createLauncher');
        });

        it('should create launcher', function () {
            var launcherObj = MainHelper.createLauncher('text', 'AppTitle'),
                app = launcherObj.getApp();
            expect(app.getName()).to.be.equal('io.ox/office/portal/text');
        });

    });
    // ========================================================================
});
