/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/editframework/utils/lineheight'
], function (LineHeight) {

    'use strict';

    // static class LineHeight ================================================

    describe('EditFramework module LineHeight', function () {

        it('should exist', function () {
            expect(LineHeight).to.be.an('object');
        });

        // constants ----------------------------------------------------------

        describe('constant', function () {
            it('"NORMAL" exists', function () {
                expect(LineHeight).to.have.a.property('NORMAL').with.a.property('type').that.is.a('string');
                expect(LineHeight).to.have.a.property('SINGLE').with.a.property('type').that.is.a('string');
                expect(LineHeight).to.have.a.property('_115').with.a.property('type').that.is.a('string');
                expect(LineHeight).to.have.a.property('ONE_HALF').with.a.property('type').that.is.a('string');
                expect(LineHeight).to.have.a.property('DOUBLE').with.a.property('type').that.is.a('string');
            });
        });
    });

    // ========================================================================
});
