/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/pagestylecollection', [
    'io.ox/office/editframework/model/stylecollection'
], function (StyleCollection) {

    'use strict';

    // definitions for page attributes
    var DEFINITIONS = {

        /**
         * Total width of a single page, in 1/100 of millimeters.
         */
        width: { def: 21000 },

        /**
         * Total height of a single page, in 1/100 of millimeters.
         */
        height: { def: 29700 }
    };

    // class PageStyleCollection ==============================================

    /**
     * A collection of style sheets for page attributes. Expected to exist by
     * the text framework that implements common text formatting on drawing
     * objects.
     *
     * @constructor
     *
     * @extends StyleCollection
     *
     * @param {SpreadsheetModel} docModel
     *  The spreadsheet document model containing this instance.
     */
    var PageStyleCollection = StyleCollection.extend({ constructor: function (docModel) {

        // base constructor ---------------------------------------------------

        StyleCollection.call(this, docModel, 'page');

        // initialization -----------------------------------------------------

        // register the attribute definitions for the style family
        docModel.registerAttributes('page', DEFINITIONS);

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docModel = null;
        });

    } }); // class PageStyleCollection

    // exports ================================================================

    return PageStyleCollection;

});
