/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 */

define('io.ox/office/presentation/view/layouttypetitlemap', [

    //'io.ox/office/tk/utils',
    //'gettext!io.ox/office/presentation/main'

], function (/*Utils, gt*/) {

    'use strict';

    // module LayoutTypeTitleMap ==============================================

    /**
     * Provides title/caption texts for any layout slide type
     * bundled into a single map for convenience.
     *
     * @constant
     */
    var LayoutTypeTitleMap = {
        // - https://intranet.open-xchange.com/wiki/documents-team:operations:presentation?&#slideattributes
        //
        //   internal ox presentation slide attributes copy text mapping:
        //
        // - when available, specific title texts derived from office 2016    // https://www.microsoft.com/Language/en-US/Search.aspx
        //   (,2013) powerpoint are used (and flagged as "pp-xxxx").          //
        //  ox attribute key:       //                                                                    //

        master:                     'Master',

        //blank:                      'Blank',                                                          // pp-2016  // en: 'Blank' - de: 'Leer'
        blank:                      'Blank',                                                          //

        chart:                      'Title and chart',
        chartAndTx:                 'Title, chart on left and text on right',
        clipArtAndTx:               'Title, clipart on left, text on right',
        clipArtAndVertTx:           'Title, clip art on left, vertical text on right',

        //cust:                       'Custom layout defined by user',                                  // pp-2016  // en: 'Custom' - de: 'Benutzerdefiniert'
        cust:                       'Custom',                                                         //

        dgm:                        'Title and diagram',
        fourObj:                    'Title and four objects',
        mediaAndTx:                 'Title, media on left, text on right',

        //obj:                        'Title and object',                                               // pp-2016  // en: 'Title and Content' - de: 'Titel und Inhalt'
        obj:                        'Title and Content',                                              //

        objAndTwoObj:               'Title, one object on left, two objects on right',
        objAndTx:                   'Title, object on left, text on right',
        objOnly:                    'Object only',
        objOverTx:                  'Title, object on top, text on bottom',

        //objTx:                      'Title, object and caption text',                                 // pp-2016  // en: 'Content with Caption' - de: 'Inhalt mit Beschriftung'
        objTx:                      'Content with Caption',                                           //

        //picTx:                      'Title, image, and caption text',                               // pp-2016  // en: 'Image with Caption' - de: 'Bild mit Beschriftung'
        picTx:                      'Image with Caption',                                           //

        //secHead:                    'Section header title and subtitle text',                         // pp-2016  // en: 'Section Header' - de: 'Abschnittsueberschrift'
        secHead:                    'Section Header',                                                 //

        tbl:                        'Title and table',

        //title:                      'Title layout with centered title and subtitle placeholders',     // pp-2016  // en: 'Title Slide' - de: 'Titelfolie'
        title:                      'Title Slide',                                                    //

        //titleOnly:                  'Title only',                                                     // pp-2016  // en: 'Title Only' - de: 'Nur Titel'
        titleOnly:                  'Title Only',                                                     //

        twoColTx:                   'Title, text on left, text on right',

        //twoObj:                     'Title, object on left, object on right',                         // pp-2016  // en: 'Two Content' - de: 'Zwei Inhalte'
        twoObj:                     'Two Content',                                                    //

        twoObjAndObj:               'Title, two objects on left, one object on right',
        twoObjAndTx:                'Title, two objects on left, text on right',
        twoObjOverTx:               'Title, two objects on top, text on bottom',

        //twoTxTwoObj:                'Title, two objects each with text',                              // pp-2016  // en: 'Title, 2 Content and Text' - de: 'Titel, zwei Inhalte und Text'
        twoTxTwoObj:                'Title, 2 Content and Text',                                      //

        tx:                         'Title and text',
        txAndChart:                 'Title, text on left and chart on right',
        txAndClipArt:               'Title, text on left, clip art on right',
        txAndMedia:                 'Title, text on left, media on right',
        txAndObj:                   'Title, text on left, object on right',
        txAndTwoObj:                'Title, text on left, two objects on right',
        txOverObj:                  'Title, text on top, object on bottom',

        //vertTitleAndTx:             'Vertical title on right, vertical text on left',                 // pp-2016  // en: 'Vertical Title and Text' - de: 'Vertikaler Titel und Text'
        vertTitleAndTx:             'Vertical Title and Text',                                        //

        vertTitleAndTxOverChart:    'Vertical title on right, vertical text on top, chart on bottom',

        //vertTx:                     'Title and vertical text body'                                    // pp-2016  // en: 'Title and Vertical Text' - de: 'Titel und vertikaler Text'
        vertTx:                     'Title and Vertical Text'                                         //
    };

    //                              https://www.microsoft.com/Language/en-US/Search.aspx              //  Order
    //                                                                                                //
    //
    //  master:
    //                              en: 'Master'
    //                              de: 'Master':
    //
    //  cust:
    //                              en: 'Custom'
    //                              de: 'Benutzerdefiniert':
    //
    //  title:                                                                                            (01)
    //                              en: 'Title Slide'
    //                              de: 'Titelfolie'
    //
    //  obj:                                                                                              (02)
    //                              en: 'Title and Content'
    //                              de: 'Titel und Inhalt'
    //
    //  secHead:                                                                                          (03)
    //                              en: 'Section Header'
    //                              de: 'Abschnittsueberschrift'
    //
    //  twoObj:                                                                                           (04)
    //                              en: 'Two Content'
    //                              de: 'Zwei Inhalte'
    //
    //  twoTxTwoObj:                                                                                      (05)
    //                              en: 'Title, 2 Content and Text'
    //                              de: 'Titel, zwei Inhalte und Text'
    //
    //  titleOnly:                                                                                        (06)
    //                              en: 'Title Only'
    //                              de: 'Nur Titel'
    //
    //  blank:                                                                                            (07)
    //                              en: 'Blank'
    //                              de: 'Leer'
    //
    //  objTx:                                                                                            (08)
    //                              en: 'Content with Caption'
    //                              de: 'Inhalt mit Beschriftung'
    //
    //  picTx:                                                                                            (09)
    //                              en: 'Image with Caption'
    //                              de: 'Bild mit Beschriftung'
    //
    //  vertTx:                                                                                           (10)
    //                              en: 'Title and Vertical Text'
    //                              de: 'Titel und vertikaler Text'
    //
    //  vertTitleAndTx:                                                                                   (11)
    //                              en: 'Vertical Title and Text'
    //                              de: 'Vertikaler Titel und Text'
    //

    // exports ================================================================

    return LayoutTypeTitleMap;

});
