/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/imagemodel', [
    'io.ox/office/drawinglayer/model/drawingmodel'
], function (DrawingModel) {

    'use strict';

    // class ImageModel =======================================================

    /**
     * The model of a picture object.
     *
     * @constructor
     *
     * @extends DrawingModel
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var ImageModel = DrawingModel.extend({ constructor: function (parentCollection, initAttributes) {

        // base constructor ---------------------------------------------------

        DrawingModel.call(this, parentCollection, 'image', initAttributes, { families: 'image line', rotatable: true });

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            parentCollection = initAttributes = null;
        });

    } }); // class ImageModel

    // exports ================================================================

    return ImageModel;

});
