/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.imageconverter.server.osgi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.config.ConfigurationService;
import com.openexchange.html.HtmlService;
import com.openexchange.imageconverter.api.IImageConverter;
import com.openexchange.imageconverter.api.ImageConverterException;
import com.openexchange.imageconverter.server.rest.ImageConverterServerRest;
import com.openexchange.osgi.HousekeepingActivator;

//=============================================================================
public class ImageConverterServerActivator extends HousekeepingActivator {
    public ImageConverterServerActivator() {
        super();
    }

    //-------------------------------------------------------------------------

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] {
            ConfigurationService.class,
            IImageConverter.class,
            HtmlService.class
        };
    }

    //-------------------------------------------------------------------------

    @Override
    protected void startBundle() throws Exception {
        LOG.info("starting bundle: " + SERVICE_NAME);

        try {
            final ConfigurationService configService = getService(ConfigurationService.class);

            m_imageConverter = getService(IImageConverter.class);

            if (null == m_imageConverter) {
                throw new ImageConverterException("Could not get ImageConverter service");
            }

            if (null == configService) {
                throw new ImageConverterException("Could not get Configuration service");
            }

            openTrackers();

            m_imageConverterServerRest = new ImageConverterServerRest(this, m_imageConverter);
            registerService(ImageConverterServerRest.class, m_imageConverterServerRest);

            LOG.info("successfully started bundle: " + SERVICE_NAME);
        } catch (Throwable e) {
            LOG.error("... starting bundle: " + SERVICE_NAME + " failed", e);
            throw new RuntimeException(e);
        }
    }

    //-------------------------------------------------------------------------

    @Override
    protected void stopBundle() throws Exception {
        LOG.info("stopping bundle: " + SERVICE_NAME);

        closeTrackers();
        unregisterServices();

        if (null != m_imageConverterServerRest) {
            m_imageConverterServerRest.shutdown();
            m_imageConverterServerRest = null;
        }

        LOG.info("successfully stopped bundle: " + SERVICE_NAME);
    }

    // - Static Members --------------------------------------------------------

    private static final String SERVICE_NAME = "Open-Xchange Image Server";

    protected final Logger LOG = LoggerFactory.getLogger(ImageConverterServerActivator.class);

    // - Members ---------------------------------------------------------------

    private IImageConverter m_imageConverter = null;

    private ImageConverterServerRest m_imageConverterServerRest = null;
}
