/* *
 *    OPEN-XCHANGE legal information
 *
 *    All intellctual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter.client.preview;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.openexchange.preview.RemoteInternalPreviewDocument;

/**
 * {@link DocumentConverterPreviewDocument}
 *
 * @author <a href="mailto:oliver.specht@open-xchange.com">Oliver Specht</a>
 */
class DocumentConverterPreviewDocument implements RemoteInternalPreviewDocument{

    private final Map<String, String> m_metaData = new HashMap<String, String>();
    private final List<String> m_content;
    private final byte[] m_previewBuffer;
    private final Boolean m_moreAvailable;

    public DocumentConverterPreviewDocument(final Map<String, String> metaData, final List<String> content, byte[] previewBuffer, Boolean moreAvailable) {
        super();

        m_metaData.putAll(metaData);
        m_content = content;
        m_previewBuffer = previewBuffer;
        m_moreAvailable = moreAvailable;
    }
    @Override
    public Map<String, String> getMetaData() {
        return m_metaData;
    }

    @Override
    public boolean hasContent() {
        return null != m_content;
    }

    @Override
    public List<String> getContent() {
        return m_content;
    }

    @Override
    public InputStream getThumbnail() {
        return ((null != m_previewBuffer) ? new ByteArrayInputStream(m_previewBuffer) : null);
    }

    @Override
    public Boolean isMoreAvailable() {
        return m_moreAvailable;
    }

    @Override
    public String toString() {
        return ((null == m_content) ? super.toString() : m_content.toString());
    }

    @Override
    public byte[] getThumbnailBuffer() {
        return m_previewBuffer;
    }

}
