/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.ContentTypeUtils;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.ContentType;

abstract class HTTPMessage {
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    HTTPMessage() {
    }

    public ContentType getContentType() {
        String value = this.getHeader("Content-Type");
        if (value == null) {
            return null;
        }
        try {
            return new ContentType(value);
        }
        catch (javax.mail.internet.ParseException parseException) {
            return null;
        }
    }

    public void setContentType(ContentType ct) {
        this.setHeader("Content-Type", ct != null ? ct.toString() : null);
    }

    public void setContentType(String ct) throws ParseException {
        try {
            this.setHeader("Content-Type", ct != null ? new ContentType(ct).toString() : null);
        }
        catch (javax.mail.internet.ParseException e) {
            throw new ParseException("Invalid Content-Type value: " + e.getMessage());
        }
    }

    public void ensureContentType() throws ParseException {
        if (this.getContentType() == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, this.getContentType());
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        } else {
            this.headers.remove(name);
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

