/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum AccountType {
    BASIC,
    PRO,
    BUSINESS;


    static class Serializer
    extends UnionSerializer<AccountType> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AccountType value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case BASIC: {
                    g.writeString("basic");
                    break;
                }
                case PRO: {
                    g.writeString("pro");
                    break;
                }
                case BUSINESS: {
                    g.writeString("business");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public AccountType deserialize(JsonParser p) throws IOException, JsonParseException {
            AccountType value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("basic".equals(tag)) {
                value = BASIC;
            } else if ("pro".equals(tag)) {
                value = PRO;
            } else if ("business".equals(tag)) {
                value = BUSINESS;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

