/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAnnotation;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.properties.BooleanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvoidDuplicateLiteralsRule
extends AbstractRule {
    private static final PropertyDescriptor SKIP_ANNOTATIONS = new BooleanProperty("skipAnnotations", "Skip literals within Annotations.", false, 1.0f);
    private static final Map<String, PropertyDescriptor> PROPERTY_DESCRIPTORS_BY_NAME = AvoidDuplicateLiteralsRule.asFixedMap(new PropertyDescriptor[]{SKIP_ANNOTATIONS});
    private static final char DEFAULT_SEPARATOR = ',';
    private static final String EXCEPTION_LIST_PROPERTY = "exceptionlist";
    private static final String SEPARATOR_PROPERTY = "separator";
    private static final String EXCEPTION_FILE_NAME_PROPERTY = "exceptionfile";
    private Map<String, List<ASTLiteral>> literals = new HashMap<String, List<ASTLiteral>>();
    private Set<String> exceptions = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.literals.clear();
        if (this.hasProperty(EXCEPTION_LIST_PROPERTY)) {
            ExceptionParser p = this.hasProperty(SEPARATOR_PROPERTY) ? new ExceptionParser(this.getStringProperty(SEPARATOR_PROPERTY).charAt(0)) : new ExceptionParser(',');
            this.exceptions = p.parse(this.getStringProperty(EXCEPTION_LIST_PROPERTY));
        } else if (this.hasProperty(EXCEPTION_FILE_NAME_PROPERTY)) {
            this.exceptions = new HashSet<String>();
            BufferedReader reader = null;
            try {
                String line;
                reader = new LineNumberReader(new BufferedReader(new FileReader(new File(this.getStringProperty(EXCEPTION_FILE_NAME_PROPERTY)))));
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    this.exceptions.add(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        super.visit(node, data);
        int threshold = this.getIntProperty("threshold");
        for (String key : this.literals.keySet()) {
            List<ASTLiteral> occurrences = this.literals.get(key);
            if (occurrences.size() < threshold) continue;
            Object[] args = new Object[]{key, occurrences.size(), occurrences.get(0).getBeginLine()};
            this.addViolation(data, (Node)occurrences.get(0), args);
        }
        return data;
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        if (node.getImage() == null || node.getImage().indexOf(34) == -1 || node.getImage().length() < 5) {
            return data;
        }
        if (this.exceptions.contains(node.getImage().substring(1, node.getImage().length() - 1))) {
            return data;
        }
        if (this.getBooleanProperty(SKIP_ANNOTATIONS) && node.getFirstParentOfType(ASTAnnotation.class) != null) {
            return data;
        }
        if (this.literals.containsKey(node.getImage())) {
            List<ASTLiteral> occurrences = this.literals.get(node.getImage());
            occurrences.add(node);
        } else {
            ArrayList<ASTLiteral> occurrences = new ArrayList<ASTLiteral>();
            occurrences.add(node);
            this.literals.put(node.getImage(), occurrences);
        }
        return data;
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return PROPERTY_DESCRIPTORS_BY_NAME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExceptionParser {
        private static final char ESCAPE_CHAR = '\\';
        private char delimiter;

        public ExceptionParser(char delimiter) {
            this.delimiter = delimiter;
        }

        public Set<String> parse(String in) {
            HashSet<String> result = new HashSet<String>();
            StringBuffer currentToken = new StringBuffer();
            boolean inEscapeMode = false;
            for (int i = 0; i < in.length(); ++i) {
                if (inEscapeMode) {
                    inEscapeMode = false;
                    currentToken.append(in.charAt(i));
                    continue;
                }
                if (in.charAt(i) == '\\') {
                    inEscapeMode = true;
                    continue;
                }
                if (in.charAt(i) == this.delimiter) {
                    result.add(currentToken.toString());
                    currentToken = new StringBuffer();
                    continue;
                }
                currentToken.append(in.charAt(i));
            }
            if (currentToken.length() > 0) {
                result.add(currentToken.toString());
            }
            return result;
        }
    }
}

