/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.request;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.operation.ChangeWanStateOperation;
import com.hazelcast.internal.management.request.ConsoleRequest;
import com.hazelcast.util.JsonUtil;
import java.io.IOException;

public class ChangeWanStateRequest
implements ConsoleRequest {
    public static final String SUCCESS = "success";
    private String schemeName;
    private String publisherName;
    private boolean start;

    public ChangeWanStateRequest() {
    }

    public ChangeWanStateRequest(String schemeName, String publisherName, boolean start) {
        this.schemeName = schemeName;
        this.publisherName = publisherName;
        this.start = start;
    }

    @Override
    public int getType() {
        return 33;
    }

    @Override
    public Object readResponse(JsonObject in) throws IOException {
        return JsonUtil.getString(in, "result", "FAILURE");
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) throws Exception {
        Object operationResult = mcs.callOnThis(new ChangeWanStateOperation(this.schemeName, this.publisherName, this.start));
        JsonObject result = new JsonObject();
        if (operationResult == null) {
            result.add("result", SUCCESS);
        } else {
            result.add("result", operationResult.toString());
        }
        out.add("result", result);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("schemeName", this.schemeName);
        root.add("publisherName", this.publisherName);
        root.add("start", this.start);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.schemeName = JsonUtil.getString(json, "schemeName");
        this.publisherName = JsonUtil.getString(json, "publisherName");
        this.start = JsonUtil.getBoolean(json, "start");
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public boolean isStart() {
        return this.start;
    }
}

