/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.data.ModuleDatabase;
import com.openexchange.osgi.worker.ProjectWorker;
import com.openexchange.osgi.worker.ResolveDependenciesWorker;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J(\u0010\u000b\u001a\u00020\t\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/openexchange/osgi/OSGiPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "logger", "Lorg/gradle/api/logging/Logger;", "apply", "", "project", "submitWork", "T", "Ljava/lang/Runnable;", "workerClass", "Ljava/lang/Class;", "projectName", "", "ActionPerformer", "Companion", "osgi"})
public final class OSGiPlugin
implements Plugin<Project> {
    private Logger logger;
    private final WorkerExecutor workerExecutor;
    @NotNull
    public static final String PLUGIN_NAME = "OSGi-Plugin";
    @NotNull
    public static ModuleDatabase moduleDatabase;
    @NotNull
    public static ConcurrentMap<String, Project> projectsPool;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Logger logger = project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        Logger logger2 = this.logger = logger;
        if (logger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger2.info("{}: Found OSGi-Root-Project: {}", (Object)PLUGIN_NAME, (Object)project.getName());
        Logger logger3 = this.logger;
        if (logger3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        moduleDatabase = new ModuleDatabase(logger3);
        projectsPool = new ConcurrentHashMap();
        Iterator iterator = project.getSubprojects().iterator();
        while (iterator.hasNext()) {
            Project p;
            Project project2 = p = (Project)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"p");
            String projectName = project2.getName();
            ConcurrentMap<String, Project> concurrentMap = projectsPool;
            if (concurrentMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectsPool");
            }
            Map map2 = concurrentMap;
            Project project3 = p;
            map2.put(projectName, project3);
            String string = projectName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectName");
            this.submitWork(ProjectWorker.class, string);
        }
        this.workerExecutor.await();
        ModuleDatabase moduleDatabase = OSGiPlugin.moduleDatabase;
        if (moduleDatabase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleDatabase");
        }
        iterator = CollectionsKt.iterator(moduleDatabase.modulesIterator());
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.submitWork(ResolveDependenciesWorker.class, key);
        }
        this.workerExecutor.await();
    }

    private final <T extends Runnable> void submitWork(Class<T> workerClass, String projectName) {
        Logger logger = this.logger;
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("{}: Submitting '{}' for project '{}'", new Object[]{PLUGIN_NAME, workerClass.getClass().getName(), projectName});
        this.workerExecutor.submit(workerClass, (Action)new ActionPerformer(projectName));
    }

    @Inject
    public OSGiPlugin(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/openexchange/osgi/OSGiPlugin$ActionPerformer;", "Lorg/gradle/api/Action;", "Lorg/gradle/workers/WorkerConfiguration;", "projectName", "", "(Ljava/lang/String;)V", "execute", "", "workerConfiguration", "osgi"})
    private static final class ActionPerformer
    implements Action<WorkerConfiguration> {
        private final String projectName;

        public void execute(@NotNull WorkerConfiguration workerConfiguration) {
            Intrinsics.checkParameterIsNotNull((Object)workerConfiguration, (String)"workerConfiguration");
            workerConfiguration.setIsolationMode(IsolationMode.NONE);
            workerConfiguration.params(new Object[]{this.projectName});
        }

        public ActionPerformer(@NotNull String projectName) {
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            this.projectName = projectName;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/openexchange/osgi/OSGiPlugin$Companion;", "", "()V", "PLUGIN_NAME", "", "moduleDatabase", "Lcom/openexchange/osgi/data/ModuleDatabase;", "getModuleDatabase", "()Lcom/openexchange/osgi/data/ModuleDatabase;", "setModuleDatabase", "(Lcom/openexchange/osgi/data/ModuleDatabase;)V", "projectsPool", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/gradle/api/Project;", "getProjectsPool", "()Ljava/util/concurrent/ConcurrentMap;", "setProjectsPool", "(Ljava/util/concurrent/ConcurrentMap;)V", "osgi"})
    public static final class Companion {
        @NotNull
        public final ModuleDatabase getModuleDatabase() {
            ModuleDatabase moduleDatabase = moduleDatabase;
            if (moduleDatabase == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"moduleDatabase");
            }
            return moduleDatabase;
        }

        public final void setModuleDatabase(@NotNull ModuleDatabase moduleDatabase) {
            Intrinsics.checkParameterIsNotNull((Object)moduleDatabase, (String)"<set-?>");
            OSGiPlugin.moduleDatabase = moduleDatabase;
        }

        @NotNull
        public final ConcurrentMap<String, Project> getProjectsPool() {
            ConcurrentMap concurrentMap = projectsPool;
            if (concurrentMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectsPool");
            }
            return concurrentMap;
        }

        public final void setProjectsPool(@NotNull ConcurrentMap<String, Project> concurrentMap) {
            Intrinsics.checkParameterIsNotNull(concurrentMap, (String)"<set-?>");
            projectsPool = concurrentMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

