/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.pns.transport.websocket;

import java.util.Map;
import com.openexchange.exception.OXException;
import com.openexchange.websockets.WebSocket;

/**
 * {@link WebSocketToClientResolver} - Resolves an open Web Socket to a certain client.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.8.3
 */
public interface WebSocketToClientResolver {

    /**
     * Gets the set containing the identifiers of all clients that are supported by this resolver
     *
     * @return The supported clients
     */
    Map<String, WebSocketClient> getSupportedClients();

    /**
     * Resolves the given open Web Socket to a client identifier that is associated with it.
     *
     * @param socket The Web Socket to resolve for
     * @return The client identifier or <code>null</code> if given Web Socket cannot be resolved
     * @throws OXException If client identifier cannot be resolved
     */
    String getClientFor(WebSocket socket) throws OXException;

    /**
     * Gets the applicable path filter expression for given client identifier.
     *
     * @param client The client identifier
     * @return The path filter expression or <code>null</code>
     * @throws OXException If path filter expression cannot be returned
     */
    String getPathFilterFor(String client) throws OXException;

}
