/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONResponse;
import com.eclipsesource.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class BoxTransactionalAPIConnection
extends BoxAPIConnection {
    private static final String SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";

    public BoxTransactionalAPIConnection(String accessToken) {
        super(accessToken);
        super.setAutoRefresh(false);
    }

    public static BoxAPIConnection getTransactionConnection(String accessToken, String scope) {
        return BoxTransactionalAPIConnection.getTransactionConnection(accessToken, scope, null);
    }

    public static BoxAPIConnection getTransactionConnection(String accessToken, String scope, String resource) {
        String urlParameters;
        URL url;
        BoxAPIConnection apiConnection = new BoxAPIConnection(accessToken);
        try {
            url = new URL(apiConnection.getTokenURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid token URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid token URL indicates a bug in the SDK.", e);
        }
        try {
            urlParameters = String.format("grant_type=%s&subject_token=%s&subject_token_type=%s&scope=%s", GRANT_TYPE, URLEncoder.encode(accessToken, "UTF-8"), SUBJECT_TOKEN_TYPE, URLEncoder.encode(scope, "UTF-8"));
            if (resource != null) {
                urlParameters = urlParameters + "&resource=" + URLEncoder.encode(resource, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxAPIException("An error occurred while attempting to encode url parameters for a transactional token request");
        }
        BoxAPIRequest request = new BoxAPIRequest(apiConnection, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        String fileToken = responseJSON.get("access_token").asString();
        BoxTransactionalAPIConnection transactionConnection = new BoxTransactionalAPIConnection(fileToken);
        transactionConnection.setExpires(responseJSON.get("expires_in").asLong() * 1000L);
        return transactionConnection;
    }

    @Override
    public void authenticate(String authCode) {
        throw new UnsupportedOperationException("BoxTransactionalAPIConnection does not support the authenticate method.");
    }

    @Override
    public boolean canRefresh() {
        return false;
    }

    @Override
    public void setAutoRefresh(boolean autoRefresh) {
        throw new UnsupportedOperationException("BoxTransactionalAPIConnection does not support token refreshing, access tokens can be generated in the developer console.");
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException("BoxTransactionalAPIConnection does not support token refreshing, access tokens can be generated in the developer console.");
    }
}

