/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.util.Preconditions;

@Beta
public class DurableExecutorConfig {
    public static final int DEFAULT_POOL_SIZE = 16;
    public static final int DEFAULT_RING_BUFFER_CAPACITY = 100;
    public static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int poolSize = 16;
    private int durability = 1;
    private int capacity = 100;
    private DurableExecutorConfigReadOnly readOnly;

    public DurableExecutorConfig() {
    }

    public DurableExecutorConfig(String name) {
        this.name = name;
    }

    public DurableExecutorConfig(String name, int poolSize, int durability, int capacity) {
        this.name = name;
        this.poolSize = poolSize;
        this.durability = durability;
        this.capacity = capacity;
    }

    public DurableExecutorConfig(DurableExecutorConfig config) {
        this(config.getName(), config.getPoolSize(), config.getDurability(), config.getCapacity());
    }

    public DurableExecutorConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new DurableExecutorConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public DurableExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public DurableExecutorConfig setPoolSize(int poolSize) {
        Preconditions.checkPositive(poolSize, "Pool size should be greater than 0");
        this.poolSize = poolSize;
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public DurableExecutorConfig setDurability(int durability) {
        Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        this.durability = durability;
        return this;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public DurableExecutorConfig setCapacity(int capacity) {
        Preconditions.checkPositive(capacity, "Capacity should be greater than 0");
        this.capacity = capacity;
        return this;
    }

    public String toString() {
        return "ExecutorConfig{name='" + this.name + '\'' + ", poolSize=" + this.poolSize + ", capacity=" + this.capacity + '}';
    }

    private static class DurableExecutorConfigReadOnly
    extends DurableExecutorConfig {
        public DurableExecutorConfigReadOnly(DurableExecutorConfig config) {
            super(config);
        }

        @Override
        public DurableExecutorConfig setName(String name) {
            throw new UnsupportedOperationException("This config is read-only durable executor: " + this.getName());
        }

        @Override
        public DurableExecutorConfig setPoolSize(int poolSize) {
            throw new UnsupportedOperationException("This config is read-only durable executor: " + this.getName());
        }

        @Override
        public DurableExecutorConfig setCapacity(int capacity) {
            throw new UnsupportedOperationException("This config is read-only durable executor: " + this.getName());
        }

        @Override
        public DurableExecutorConfig setDurability(int durability) {
            throw new UnsupportedOperationException("This config is read-only durable executor: " + this.getName());
        }
    }
}

