/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientDestroyRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import com.hazelcast.util.ExceptionUtil;

abstract class ClientTxnProxy
implements TransactionalObject {
    final String objectName;
    final ClientTransactionContext transactionContext;

    ClientTxnProxy(String objectName, ClientTransactionContext transactionContext) {
        this.objectName = objectName;
        this.transactionContext = transactionContext;
    }

    final <T> T invoke(ClientRequest request) {
        if (request instanceof BaseTransactionRequest) {
            ((BaseTransactionRequest)request).setTxnId(this.transactionContext.getTxnId());
            ((BaseTransactionRequest)request).setClientThreadId(Thread.currentThread().getId());
        }
        HazelcastClientInstanceImpl client = this.transactionContext.getClient();
        SerializationService ss = client.getSerializationService();
        try {
            ClientInvocation invocation = new ClientInvocation(client, request, this.transactionContext.getConnection());
            ClientInvocationFuture future = invocation.invoke();
            return ss.toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    abstract void onDestroy();

    @Override
    public final void destroy() {
        this.onDestroy();
        ClientDestroyRequest request = new ClientDestroyRequest(this.objectName, this.getServiceName());
        this.invoke(request);
    }

    @Override
    public Object getId() {
        return this.objectName;
    }

    @Override
    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey(this.getName());
    }

    Data toData(Object obj) {
        return this.transactionContext.getClient().getSerializationService().toData(obj);
    }

    Object toObject(Data data) {
        return this.transactionContext.getClient().getSerializationService().toObject(data);
    }
}

