/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAsyncCodec;
import com.hazelcast.client.impl.protocol.task.AbstractPartitionMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.RemoveOperation;
import com.hazelcast.nio.Connection;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.security.Permission;

public class MapRemoveAsyncMessageTask
extends AbstractPartitionMessageTask<MapRemoveAsyncCodec.RequestParameters> {
    protected transient long startTime;

    public MapRemoveAsyncMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(((MapRemoveAsyncCodec.RequestParameters)this.parameters).name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(((MapRemoveAsyncCodec.RequestParameters)this.parameters).name).incrementRemoves(latency);
        }
    }

    @Override
    protected Operation prepareOperation() {
        RemoveOperation op = new RemoveOperation(((MapRemoveAsyncCodec.RequestParameters)this.parameters).name, ((MapRemoveAsyncCodec.RequestParameters)this.parameters).key);
        op.setThreadId(((MapRemoveAsyncCodec.RequestParameters)this.parameters).threadId);
        return op;
    }

    @Override
    protected MapRemoveAsyncCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapRemoveAsyncCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapRemoveAsyncCodec.encodeResponse(this.serializationService.toData(response));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapRemoveAsyncCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapRemoveAsyncCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "removeAsync";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapRemoveAsyncCodec.RequestParameters)this.parameters).key};
    }
}

