/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.eviction.Evictable;
import com.hazelcast.cache.impl.eviction.EvictionCandidate;
import com.hazelcast.cache.impl.eviction.EvictionListener;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.SampleableCacheRecordMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import com.hazelcast.util.SampleableConcurrentHashMap;
import java.util.ArrayList;
import java.util.EnumSet;

public class CacheRecordHashMap
extends SampleableConcurrentHashMap<Data, CacheRecord>
implements SampleableCacheRecordMap<Data, CacheRecord> {
    private static final long serialVersionUID = 1L;
    private final transient CacheContext cacheContext;

    public CacheRecordHashMap(int initialCapacity, CacheContext cacheContext) {
        super(initialCapacity);
        this.cacheContext = cacheContext;
    }

    public CacheRecordHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options, CacheContext cacheContext) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options);
        this.cacheContext = cacheContext;
    }

    @Override
    public CacheRecord put(Data key, CacheRecord value) {
        CacheRecord oldRecord = super.put(key, value);
        if (oldRecord == null) {
            this.cacheContext.increaseEntryCount();
        }
        return oldRecord;
    }

    @Override
    public CacheRecord putIfAbsent(Data key, CacheRecord value) {
        CacheRecord oldRecord = super.putIfAbsent(key, value);
        if (oldRecord == null) {
            this.cacheContext.increaseEntryCount();
        }
        return oldRecord;
    }

    @Override
    public CacheRecord remove(Object key) {
        CacheRecord removedRecord = (CacheRecord)super.remove(key);
        if (removedRecord != null) {
            this.cacheContext.decreaseEntryCount();
        }
        return removedRecord;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.cacheContext.decreaseEntryCount();
        }
        return removed;
    }

    @Override
    public void clear() {
        int sizeBeforeClear = this.size();
        super.clear();
        this.cacheContext.decreaseEntryCount(sizeBeforeClear);
    }

    @Override
    protected EvictableSamplingEntry createSamplingEntry(Data key, CacheRecord value) {
        return new EvictableSamplingEntry(key, value);
    }

    @Override
    public CacheKeyIteratorResult fetchNext(int nextTableIndex, int size) {
        ArrayList<Data> keys = new ArrayList<Data>();
        int tableIndex = this.fetch(nextTableIndex, size, keys);
        return new CacheKeyIteratorResult(keys, tableIndex);
    }

    @Override
    public <C extends EvictionCandidate<Data, CacheRecord>> int evict(Iterable<C> evictionCandidates, EvictionListener<Data, CacheRecord> evictionListener) {
        if (evictionCandidates == null) {
            return 0;
        }
        int actualEvictedCount = 0;
        for (EvictionCandidate evictionCandidate : evictionCandidates) {
            if (this.remove(evictionCandidate.getAccessor()) == null) continue;
            ++actualEvictedCount;
            if (evictionListener == null) continue;
            evictionListener.onEvict((Data)evictionCandidate.getAccessor(), (CacheRecord)evictionCandidate.getEvictable());
        }
        return actualEvictedCount;
    }

    @Override
    public Iterable<EvictableSamplingEntry> sample(int sampleCount) {
        return super.getRandomSamples(sampleCount);
    }

    public class EvictableSamplingEntry
    extends SampleableConcurrentHashMap.SamplingEntry
    implements EvictionCandidate {
        public EvictableSamplingEntry(Data key, CacheRecord value) {
            super(CacheRecordHashMap.this, key, value);
        }

        public Object getAccessor() {
            return this.getKey();
        }

        public Evictable getEvictable() {
            return (Evictable)this.getValue();
        }
    }
}

