/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.data;

import com.openexchange.projectset.data.CVSRepository;
import com.openexchange.projectset.data.GitRepository;
import com.openexchange.projectset.data.Repository;
import com.openexchange.projectset.data.RepositoryType;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ProjectSetFileReader {
    private final Map<String, Repository> projects = new HashMap<String, Repository>();
    private final List<String> projectList = new ArrayList<String>();

    public ProjectSetFileReader(File file) {
        this.parse(file);
    }

    public Map<String, Repository> getProjects() {
        return this.projects;
    }

    public List<String> getProjectList() {
        return this.projectList;
    }

    private void parse(File file) {
        try {
            Document document = new SAXBuilder().build(file);
            Element psf = document.getRootElement();
            if (!"psf".equals(psf.getName())) {
                throw new BuildException("Root element is not a PSF but a " + psf.toString());
            }
            for (Object tmp : psf.getChildren()) {
                if (!(tmp instanceof Element)) {
                    throw new BuildException("PSF child is not an element but a " + tmp.getClass().getName());
                }
                for (Repository repository : ProjectSetFileReader.parseProvider((Element)tmp)) {
                    this.projects.put(repository.getProjectName(), repository);
                    this.projectList.add(repository.getProjectName());
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            throw new BuildException(sw.toString());
        }
    }

    public static Map<String, Repository> parseMap(String projectSetFileName) {
        try {
            Document document = new SAXBuilder().build(new File(projectSetFileName));
            Element psf = document.getRootElement();
            if (!"psf".equals(psf.getName())) {
                throw new BuildException("Root element is not a PSF but a " + psf.toString());
            }
            HashMap<String, Repository> projects = new HashMap<String, Repository>();
            for (Object tmp : psf.getChildren()) {
                if (!(tmp instanceof Element)) {
                    throw new BuildException("PSF child is not an element but a " + tmp.getClass().getName());
                }
                for (Repository repository : ProjectSetFileReader.parseProvider((Element)tmp)) {
                    projects.put(repository.getProjectName(), repository);
                }
            }
            return projects;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            throw new BuildException(sw.toString());
        }
    }

    private static List<Repository> parseProvider(Element providerElement) {
        if (!"provider".equals(providerElement.getName())) {
            throw new BuildException("PSF child is not a provider but a " + providerElement.getName());
        }
        Attribute id = providerElement.getAttribute("id");
        if (null == id) {
            throw new BuildException("Attribute id for tag provider is missing");
        }
        String providerName = id.getValue();
        RepositoryType type = RepositoryType.byProvider(providerName);
        if (null == type) {
            throw new BuildException("Unknown provider " + providerName);
        }
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Object tmp : providerElement.getChildren()) {
            if (!(tmp instanceof Element)) {
                throw new BuildException("Provider child is not an element but a " + tmp.getClass().getName());
            }
            repositories.add(ProjectSetFileReader.parseProject((Element)tmp, type));
        }
        return repositories;
    }

    private static Repository parseProject(Element projectElement, RepositoryType type) {
        Repository repository;
        if (!"project".equals(projectElement.getName())) {
            throw new BuildException("Provider child is not a project but a " + projectElement.getName());
        }
        Attribute reference = projectElement.getAttribute("reference");
        if (null == reference) {
            throw new BuildException("Attribute reference for tag project is missing");
        }
        String projectReference = reference.getValue();
        switch (type) {
            case CVS: {
                repository = CVSRepository.parseCVSReference(projectReference);
                break;
            }
            case SVN: {
                throw new BuildException("Parsing a SVN repository reference is currently not implemented.");
            }
            case Git: {
                repository = GitRepository.parseGitReference(projectReference);
                break;
            }
            default: {
                throw new BuildException("Unknown repository type " + type.name());
            }
        }
        return repository;
    }
}

