/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Julian Bäume <julian.baeume@open-xchange.com>
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

(function () {

    'use strict';

    //
    // Plugin functions
    //

    // this is called for each editor instance
    function init(ed, url) {
        var view = null, panelId = 'emoji-' + ed.id;

        // load required code now
        require(['io.ox/core/emoji/view'], function (EmojiView) {
            // create instance only once per editor
            view = new EmojiView({ editor: ed });
        });
        function renderView() {
            return '<div id="' + panelId + '">';
        }
        var recalculatePosition = _.debounce(function () {
            if (!view) return;
            var rect = view.$el.get(0).getBoundingClientRect(),
                windowHeight = $(window).height(),
                parent = view.$el.closest('.mce-container'),
                arrow = parent.find('.mce-arrow');
            if (rect.bottom > windowHeight) {
                var top = parseInt(parent.css('top'), 10); // yep kind of strange, but the container has some strange margins
                parent.css('top', (top - (rect.bottom - windowHeight)) + 'px');
            }
            arrow.toggle(rect.bottom < windowHeight);
        }, 1);

        // TODO: translate title
        ed.addButton('emoji', {
            type: 'panelbutton',
            tooltip: 'Emoticons',
            icon: 'emoticons',
            panel: {
                layout: 'grid',
                role: "application",
                html: renderView,
                onPostRender: function () {
                    this.on('show', function () {
                        if ($('#' + panelId).is(':empty') && view) {
                            $('#' + panelId).append(view.$el);
                        }
                        if (view) {
                            view.toggle();
                            // Set layout information of tinymce to bounds of content
                            // This does not work automatically due to deferred rendering of the view
                            var boundingRect = view.$el.get(0).getBoundingClientRect(),
                                layoutRect = {};
                            layoutRect.w = boundingRect.width + 2;
                            layoutRect.innerW = layoutRect.contentW = boundingRect.width;
                            layoutRect.h = boundingRect.height + 2;
                            layoutRect.innerH = layoutRect.height = boundingRect.height;
                            this.layoutRect(layoutRect);
                            this.reflow();
                        }
                        recalculatePosition();
                    })
                    .on('hide', function () {
                        if (view) view.toggle();
                    });
                }
        }

        });
    }

    window.tinymce.PluginManager.add('emoji', init);

}());
