/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.servlet.Servlet;
import org.glassfish.grizzly.servlet.ExpectationHandler;
import org.glassfish.grizzly.servlet.Registration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.utils.ArraySet;

public class ServletRegistration
extends Registration
implements Comparable<ServletRegistration> {
    protected Class<? extends Servlet> servletClass;
    protected ArraySet<String> urlPatterns = new ArraySet(String.class);
    protected Servlet servlet;
    protected int loadOnStartup = -1;
    protected ExpectationHandler expectationHandler;

    protected ServletRegistration(WebappContext ctx, String name, String servletClassName) {
        super(ctx, name, servletClassName);
        this.name = name;
    }

    protected ServletRegistration(WebappContext ctx, String name, Servlet servlet) {
        this(ctx, name, servlet.getClass());
        this.servlet = servlet;
    }

    protected ServletRegistration(WebappContext ctx, String name, Class<? extends Servlet> servletClass) {
        this(ctx, name, servletClass.getName());
        this.servletClass = servletClass;
    }

    public Set<String> addMapping(String ... urlPatterns) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException("'urlPatterns' cannot be null or zero-length");
        }
        this.urlPatterns.addAll((Object[])urlPatterns);
        return Collections.emptySet();
    }

    public Collection<String> getMappings() {
        return Collections.unmodifiableList(Arrays.asList((String[])this.urlPatterns.getArrayCopy()));
    }

    public void setLoadOnStartup(int loadOnStartup) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.loadOnStartup = loadOnStartup < 0 ? -1 : loadOnStartup;
    }

    public ExpectationHandler getExpectationHandler() {
        return this.expectationHandler;
    }

    public void setExpectationHandler(ExpectationHandler expectationHandler) {
        this.expectationHandler = expectationHandler;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServletRegistration");
        sb.append("{ servletName=").append(this.name);
        sb.append(", servletClass=").append(this.className);
        sb.append(", urlPatterns=").append(Arrays.toString(this.urlPatterns.getArray()));
        sb.append(", loadOnStartup=").append(this.loadOnStartup);
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public int compareTo(ServletRegistration o) {
        if (this.loadOnStartup == o.loadOnStartup) {
            return 0;
        }
        if (this.loadOnStartup < 0 && o.loadOnStartup < 0) {
            return -1;
        }
        if (this.loadOnStartup >= 0 && o.loadOnStartup >= 0 && this.loadOnStartup < o.loadOnStartup) {
            return -1;
        }
        return 1;
    }
}

