/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.WebappContext;

public class HttpSessionImpl
implements HttpSession {
    private static final Logger LOGGER = Grizzly.logger(HttpSessionImpl.class);
    private Session session;
    private final WebappContext contextImpl;
    private Long creationTime;
    private Long lastAccessed;
    private boolean isNew = true;

    public HttpSessionImpl(WebappContext contextImpl) {
        this.contextImpl = contextImpl;
        this.lastAccessed = this.creationTime = Long.valueOf(System.currentTimeMillis());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.session.getIdInternal();
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    protected void access() {
        this.lastAccessed = System.currentTimeMillis();
        this.session.setTimestamp(this.lastAccessed.longValue());
        this.isNew = false;
    }

    public ServletContext getServletContext() {
        return this.contextImpl;
    }

    public void setMaxInactiveInterval(int sessionTimeout) {
        sessionTimeout = sessionTimeout < 0 ? -1 : (sessionTimeout *= 1000);
        this.session.setSessionTimeout((long)sessionTimeout);
    }

    public int getMaxInactiveInterval() {
        long sessionTimeout = this.session.getSessionTimeout();
        if (sessionTimeout < 0L) {
            return -1;
        }
        if ((sessionTimeout /= 1000L) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.valueOf(sessionTimeout) + " cannot be cast to int.");
        }
        return (int)sessionTimeout;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String key) {
        return this.session.getAttribute(key);
    }

    public Object getValue(String value) {
        return this.session.getAttribute(value);
    }

    public Enumeration getAttributeNames() {
        return this.session.attributes().keys();
    }

    public String[] getValueNames() {
        return this.session.attributes().entrySet().toArray(new String[this.session.attributes().size()]);
    }

    public void setAttribute(String key, Object value) {
        EventListener[] listeners;
        HttpSessionBindingEvent event;
        Object unbound;
        block17: {
            block16: {
                if (value == null) {
                    this.removeAttribute(key);
                    return;
                }
                unbound = this.session.getAttribute(key);
                this.session.setAttribute(key, value);
                if (unbound != null && unbound != value && unbound instanceof HttpSessionBindingListener) {
                    try {
                        ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, key));
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block16;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_SESSION_LISTENER_UNBOUND_ERROR((Object)unbound.getClass().getName()));
                    }
                }
            }
            event = null;
            if (value instanceof HttpSessionBindingListener && value != unbound) {
                event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                try {
                    ((HttpSessionBindingListener)value).valueBound(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block17;
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_SESSION_LISTENER_BOUND_ERROR((Object)value.getClass().getName()));
                }
            }
        }
        if ((listeners = this.contextImpl.getEventListeners()).length == 0) {
            return;
        }
        int i = 0;
        int len = listeners.length;
        while (i < len) {
            block18: {
                if (listeners[i] instanceof HttpSessionAttributeListener) {
                    HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                    try {
                        if (unbound != null) {
                            if (event == null) {
                                event = new HttpSessionBindingEvent((HttpSession)this, key, unbound);
                            }
                            listener.attributeReplaced(event);
                        } else {
                            if (event == null) {
                                event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                            }
                            listener.attributeAdded(event);
                        }
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block18;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR((Object)"HttpSessionAttributeListener", (Object)listener.getClass().getName()), t);
                    }
                }
            }
            ++i;
        }
    }

    public void putValue(String key, Object value) {
        this.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        EventListener[] listeners;
        Object value = this.session.removeAttribute(key);
        if (value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = this.contextImpl.getEventListeners()).length == 0) {
            return;
        }
        int i = 0;
        int len = listeners.length;
        while (i < len) {
            block8: {
                if (listeners[i] instanceof HttpSessionAttributeListener) {
                    HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                    try {
                        if (event == null) {
                            event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                        }
                        listener.attributeRemoved(event);
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block8;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR((Object)"HttpSessionAttributeListener", (Object)listener.getClass().getName()), t);
                    }
                }
            }
            ++i;
        }
    }

    public void removeValue(String key) {
        this.removeAttribute(key);
    }

    public synchronized void invalidate() {
        this.session.setValid(false);
        this.session.attributes().clear();
        this.creationTime = 0L;
        this.isNew = true;
        EventListener[] listeners = this.contextImpl.getEventListeners();
        if (listeners.length > 0) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            int i = 0;
            int len = listeners.length;
            while (i < len) {
                block5: {
                    EventListener listenerObj = listeners[i];
                    if (listenerObj instanceof HttpSessionListener) {
                        HttpSessionListener listener = (HttpSessionListener)listenerObj;
                        try {
                            listener.sessionDestroyed(event);
                        }
                        catch (Throwable t) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR((Object)"sessionDestroyed", (Object)"HttpSessionListener", (Object)listener.getClass().getName()), t);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void notifyNew() {
        EventListener[] listeners = this.contextImpl.getEventListeners();
        if (listeners.length > 0) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            int i = 0;
            int len = listeners.length;
            while (i < len) {
                block5: {
                    EventListener listenerObj = listeners[i];
                    if (listenerObj instanceof HttpSessionListener) {
                        HttpSessionListener listener = (HttpSessionListener)listenerObj;
                        try {
                            listener.sessionCreated(event);
                        }
                        catch (Throwable t) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR((Object)"sessionCreated", (Object)"HttpSessionListener", (Object)listener.getClass().getName()), t);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

