/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft06;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.draft06.SecKey;

public class HandShake06
extends HandShake {
    private final SecKey secKey;
    private List<String> enabledExtensions = Collections.emptyList();
    private List<String> enabledProtocols = Collections.emptyList();

    public HandShake06(URI url) {
        super(url);
        this.secKey = new SecKey();
    }

    public HandShake06(HttpRequestPacket request) {
        super(request);
        MimeHeaders mimeHeaders = request.getHeaders();
        this.setExtensions(this.split(mimeHeaders.getHeader("Sec-WebSocket-Extensions")));
        this.secKey = SecKey.generateServerKey(new SecKey(mimeHeaders.getHeader("Sec-WebSocket-Key")));
    }

    @Override
    public void setHeaders(HttpResponsePacket response) {
        response.setReasonPhrase("Switching Protocols");
        response.setHeader("Sec-WebSocket-Accept", this.secKey.getSecKey());
        if (!this.getEnabledExtensions().isEmpty()) {
            response.setHeader("Sec-WebSocket-Extensions", this.join(this.getSubProtocol()));
        }
    }

    @Override
    public HttpContent composeHeaders() {
        HttpContent httpContent = super.composeHeaders();
        HttpHeader header = httpContent.getHttpHeader();
        header.addHeader("Sec-WebSocket-Key", this.secKey.toString());
        header.addHeader("Sec-WebSocket-Origin", this.getOrigin());
        header.addHeader("Sec-WebSocket-Version", String.valueOf(this.getVersion()));
        if (!this.getExtensions().isEmpty()) {
            header.addHeader("Sec-WebSocket-Extensions", this.join(this.getExtensions()));
        }
        return httpContent;
    }

    protected int getVersion() {
        return 6;
    }

    @Override
    public void validateServerResponse(HttpResponsePacket headers) throws HandshakeException {
        super.validateServerResponse(headers);
        this.secKey.validateServerKey(headers.getHeader("Sec-WebSocket-Accept"));
    }

    public List<String> getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }
}

