/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.draft06.Draft06Handler;
import org.glassfish.grizzly.websockets.draft07.Draft07Handler;
import org.glassfish.grizzly.websockets.draft08.Draft08Handler;
import org.glassfish.grizzly.websockets.draft17.Draft17Handler;

public enum Version {
    DRAFT17("13"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft17Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT08("8"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft08Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT07("7"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft07Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT06("6"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft06Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    };

    String wireProtocolVersion;

    public abstract ProtocolHandler createHandler(boolean var1);

    public abstract boolean validate(MimeHeaders var1);

    private Version(String wireProtocolVersion) {
        this.wireProtocolVersion = wireProtocolVersion;
    }

    public String toString() {
        return this.name();
    }

    public boolean isFragmentationSupported() {
        return true;
    }

    public static String getSupportedWireProtocolVersions() {
        StringBuilder sb = new StringBuilder();
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version v = versionArray[n2];
            if (v.wireProtocolVersion.length() > 0) {
                sb.append(v.wireProtocolVersion).append(", ");
            }
            ++n2;
        }
        return sb.substring(0, sb.length() - 2);
    }

    /* synthetic */ Version(String string, int n, String string2, Version version) {
        this(string2);
    }
}

