/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public final class FileIterator {
    private final LinkedList<File> stack = new LinkedList();
    private File current;

    public FileIterator(File ... filesOrDirectories) {
        this.addReverse(filesOrDirectories);
    }

    public File getFile() {
        return this.current;
    }

    public File next() throws IOException {
        if (this.stack.isEmpty()) {
            return null;
        }
        this.current = this.stack.removeLast();
        if (this.current.isDirectory()) {
            this.addReverse(this.current.listFiles());
            return this.next();
        }
        return this.current;
    }

    private void addReverse(File[] files) {
        for (int i = files.length - 1; i >= 0; --i) {
            this.stack.add(files[i]);
        }
    }
}

