/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.C2BConverter;

public final class UEncoder {
    private static final Logger logger = Grizzly.logger(UEncoder.class);
    private BitSet safeChars = null;
    private C2BConverter c2b = null;
    private ByteChunk bb = null;
    private String encoding = "UTF8";
    private static final int debug = 0;

    public UEncoder() {
        this.initSafeChars();
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void addSafeCharacter(char c) {
        this.safeChars.set(c);
    }

    public void urlEncode(Writer buf, String s) throws IOException {
        this.urlEncode(buf, s, false);
    }

    public void urlEncode(Writer buf, String s, boolean toHexUpperCase) throws IOException {
        if (this.c2b == null) {
            this.bb = new ByteChunk(16);
            this.c2b = C2BConverter.getInstance(this.bb, this.encoding);
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (this.safeChars.get(c)) {
                buf.write(c);
            } else {
                char d;
                this.c2b.convert(c);
                if (c >= '\ud800' && c <= '\udbff' && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    this.c2b.convert(d);
                    ++i;
                }
                this.urlEncode(buf, this.bb.getBuffer(), this.bb.getStart(), this.bb.getLength(), toHexUpperCase);
                this.bb.recycle();
            }
            ++i;
        }
    }

    public void urlEncode(Writer buf, byte[] bytes, int off, int len) throws IOException {
        this.urlEncode(buf, bytes, off, len, false);
    }

    public void urlEncode(Writer buf, byte[] bytes, int off, int len, boolean toHexUpperCase) throws IOException {
        int j = off;
        while (j < len) {
            buf.write(37);
            char ch = Character.forDigit(bytes[j] >> 4 & 0xF, 16);
            if (toHexUpperCase) {
                ch = Character.toUpperCase(ch);
            }
            buf.write(ch);
            ch = Character.forDigit(bytes[j] & 0xF, 16);
            if (toHexUpperCase) {
                ch = Character.toUpperCase(ch);
            }
            buf.write(ch);
            ++j;
        }
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, false);
    }

    public String encodeURL(String uri, boolean toHexUpperCase) {
        String outUri = null;
        try {
            CharArrayWriter out = new CharArrayWriter();
            this.urlEncode(out, uri, toHexUpperCase);
            outUri = out.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outUri;
    }

    private void initSafeChars() {
        this.safeChars = new BitSet(128);
        int i = 97;
        while (i <= 122) {
            this.safeChars.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            this.safeChars.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            this.safeChars.set(i);
            ++i;
        }
        this.safeChars.set(36);
        this.safeChars.set(45);
        this.safeChars.set(95);
        this.safeChars.set(46);
        this.safeChars.set(33);
        this.safeChars.set(42);
        this.safeChars.set(39);
        this.safeChars.set(40);
        this.safeChars.set(41);
        this.safeChars.set(44);
    }

    private static void log(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(s);
        }
    }
}

