/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaderField;
import org.glassfish.grizzly.http.util.NamesIterator;
import org.glassfish.grizzly.http.util.ValuesIterator;

public class MimeHeaders {
    public static final int MAX_NUM_HEADERS_UNBOUNDED = -1;
    public static final int MAX_NUM_HEADERS_DEFAULT = 100;
    public static final int DEFAULT_HEADER_SIZE = 8;
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private int maxNumHeaders = 100;
    private final Iterable<String> namesIterable = new Iterable<String>(){

        @Override
        public Iterator<String> iterator() {
            return new NamesIterator(MimeHeaders.this);
        }
    };

    public void recycle() {
        this.clear();
    }

    public void clear() {
        int i = 0;
        while (i < this.count) {
            this.headers[i].recycle();
            ++i;
        }
        this.count = 0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== MimeHeaders ===");
        for (String name : this.names()) {
            pw.println(String.valueOf(name) + " = " + this.getHeader(name));
        }
        return sw.toString();
    }

    public int size() {
        return this.count;
    }

    public DataChunk getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public DataChunk getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public boolean getAndSetSerialized(int n, boolean newValue) {
        boolean value;
        if (n >= 0 && n < this.count) {
            MimeHeaderField field = this.headers[n];
            value = field.isSerialized();
            field.setSerialized(newValue);
        } else {
            value = true;
        }
        return value;
    }

    public int indexOf(String name, int fromIndex) {
        int i = fromIndex;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(Header header, int fromIndex) {
        byte[] bytes = header.getLowerCaseBytes();
        int i = fromIndex;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCaseLowerCase(bytes)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(Header header) {
        return this.indexOf(header, 0) >= 0;
    }

    public boolean contains(String header) {
        return this.indexOf(header, 0) >= 0;
    }

    public Iterable<String> names() {
        return this.namesIterable;
    }

    public Iterable<String> values(final String name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name);
            }
        };
    }

    public Iterable<String> values(final Header name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name.toString());
            }
        };
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        if (this.maxNumHeaders >= 0 && this.count == this.maxNumHeaders) {
            throw new MaxHeaderCountExceededException();
        }
        int len = this.headers.length;
        if (this.count >= len) {
            int newCount = this.count * 2;
            if (this.maxNumHeaders >= 0 && newCount > this.maxNumHeaders) {
                newCount = this.maxNumHeaders;
            }
            MimeHeaderField[] tmp = new MimeHeaderField[newCount];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public DataChunk addValue(String name) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk addValue(Header header) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setBytes(header.toByteArray());
        return mh.getValue();
    }

    public DataChunk addValue(byte[] buffer, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(buffer, startN, startN + len);
        return mhf.getValue();
    }

    public DataChunk addValue(Buffer buffer, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBuffer(buffer, startN, startN + len);
        return mhf.getValue();
    }

    public DataChunk setValue(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(name)) {
                int j = i + 1;
                while (j < this.count) {
                    if (this.headers[j].getName().equalsIgnoreCase(name)) {
                        this.removeHeader(j--);
                    }
                    ++j;
                }
                return this.headers[i].getValue();
            }
            ++i;
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk setValue(Header header) {
        byte[] bytes = header.getLowerCaseBytes();
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCaseLowerCase(bytes)) {
                int j = i + 1;
                while (j < this.count) {
                    if (this.headers[j].getName().equalsIgnoreCaseLowerCase(bytes)) {
                        this.removeHeader(j--);
                    }
                    ++j;
                }
                return this.headers[i].getValue();
            }
            ++i;
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setBytes(header.toByteArray());
        return mh.getValue();
    }

    public DataChunk getValue(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(name)) {
                return this.headers[i].getValue();
            }
            ++i;
        }
        return null;
    }

    public DataChunk getValue(Header header) {
        byte[] bytes = header.getLowerCaseBytes();
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCaseLowerCase(bytes)) {
                return this.headers[i].getValue();
            }
            ++i;
        }
        return null;
    }

    public String getHeader(String name) {
        DataChunk mh = this.getValue(name);
        return mh != null ? mh.toString() : null;
    }

    public String getHeader(Header header) {
        DataChunk mh = this.getValue(header);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(name)) {
                this.removeHeader(i--);
            }
            ++i;
        }
    }

    public void removeHeader(Header header) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(header.getBytes())) {
                this.removeHeader(i--);
            }
            ++i;
        }
    }

    public void removeHeader(String name, String str) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(name) && this.getValue(i) != null && this.getValue(i).toString() != null && this.getValue(i).toString().contains(str)) {
                this.removeHeader(i--);
            }
            ++i;
        }
    }

    public void removeHeaderMatches(String name, String regex) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCase(name) && this.getValue(i) != null && this.getValue(i).toString() != null && this.getValue(i).toString().matches(regex)) {
                this.removeHeader(i--);
            }
            ++i;
        }
    }

    public void removeHeaderMatches(Header header, String regex) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].getName().equalsIgnoreCaseLowerCase(header.getLowerCaseBytes()) && this.getValue(i) != null && this.getValue(i).toString() != null && this.getValue(i).toString().matches(regex)) {
                this.removeHeader(i--);
            }
            ++i;
        }
    }

    void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        this.headers[idx] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mh;
        --this.count;
    }

    public void setMaxNumHeaders(int maxNumHeaders) {
        this.maxNumHeaders = maxNumHeaders;
    }

    public int getMaxNumHeaders() {
        return this.maxNumHeaders;
    }

    public class MaxHeaderCountExceededException
    extends IllegalStateException {
        public MaxHeaderCountExceededException() {
            super("Illegal attempt to exceed the configured maximum number of headers: " + MimeHeaders.this.maxNumHeaders);
        }
    }
}

