/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;

public class HttpUtils {
    private static final float[] MULTIPLIERS = new float[]{0.1f, 0.01f, 0.001f};

    public static float convertQValueToFloat(DataChunk dc, int startIdx, int stopIdx) {
        float qvalue = 0.0f;
        DataChunk.Type type = dc.getType();
        try {
            switch (type) {
                case String: {
                    qvalue = HttpUtils.convertQValueToFloat(dc.toString(), startIdx, stopIdx);
                    break;
                }
                case Buffer: {
                    qvalue = HttpUtils.convertQValueToFloat(dc.getBufferChunk().getBuffer(), startIdx, stopIdx);
                    break;
                }
                case Chars: {
                    qvalue = HttpUtils.convertQValueToFloat(dc.getCharChunk().getChars(), startIdx, stopIdx);
                }
            }
        }
        catch (Exception e) {
            qvalue = 0.0f;
        }
        return qvalue;
    }

    /*
     * Unable to fully structure code
     */
    public static float convertQValueToFloat(Buffer buffer, int startIdx, int stopIdx) {
        result = 0.0f;
        firstDigitProcessed = false;
        multIdx = -1;
        i = 0;
        len = stopIdx - startIdx;
        while (i < len) {
            c = (char)buffer.get(i + startIdx);
            if (multIdx != -1) ** GOTO lbl-1000
            if (firstDigitProcessed && c != '.') {
                throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
            }
            if (c == '.') {
                multIdx = 0;
            } else if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (result > 1.0f) {
                        throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                    }
                } else {
                    if (multIdx >= HttpUtils.MULTIPLIERS.length) {
                        throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                    }
                    result += (float)Character.digit(c, 10) * HttpUtils.MULTIPLIERS[multIdx++];
                }
            } else {
                throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static float convertQValueToFloat(String string, int startIdx, int stopIdx) {
        result = 0.0f;
        firstDigitProcessed = false;
        multIdx = -1;
        i = 0;
        len = stopIdx - startIdx;
        while (i < len) {
            c = string.charAt(i + startIdx);
            if (multIdx != -1) ** GOTO lbl-1000
            if (firstDigitProcessed && c != '.') {
                throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
            }
            if (c == '.') {
                multIdx = 0;
            } else if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (result > 1.0f) {
                        throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                    }
                } else {
                    if (multIdx >= HttpUtils.MULTIPLIERS.length) {
                        throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                    }
                    result += (float)Character.digit(c, 10) * HttpUtils.MULTIPLIERS[multIdx++];
                }
            } else {
                throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static float convertQValueToFloat(char[] chars, int startIdx, int stopIdx) {
        result = 0.0f;
        firstDigitProcessed = false;
        multIdx = -1;
        i = 0;
        len = stopIdx - startIdx;
        while (i < len) {
            c = chars[i + startIdx];
            if (multIdx != -1) ** GOTO lbl-1000
            if (firstDigitProcessed && c != '.') {
                throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
            }
            if (c == '.') {
                multIdx = 0;
            } else if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (result > 1.0f) {
                        throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                    }
                } else {
                    if (multIdx >= HttpUtils.MULTIPLIERS.length) {
                        throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                    }
                    result += (float)Character.digit(c, 10) * HttpUtils.MULTIPLIERS[multIdx++];
                }
            } else {
                throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
            }
            ++i;
        }
        return result;
    }

    public static int longToBuffer(long value, byte[] buffer) {
        boolean negative;
        int i = buffer.length;
        if (value == 0L) {
            buffer[--i] = 48;
            return i;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        do {
            int ch = 48 + (int)(value % 10L);
            buffer[--i] = (byte)ch;
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer[--i] = 45;
        }
        return i;
    }

    public static void longToBuffer(long value, Buffer buffer) {
        boolean negative;
        if (value == 0L) {
            buffer.put(0, (byte)48);
            buffer.limit(1);
            return;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        int position = buffer.limit();
        do {
            int ch = 48 + (int)(value % 10L);
            buffer.put(--position, (byte)ch);
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer.put(--position, (byte)45);
        }
        buffer.position(position);
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char aContent = cArray[n2];
            switch (aContent) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                default: {
                    result.append(aContent);
                }
            }
            ++n2;
        }
        return result.toString();
    }
}

