/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.TransferEncoding;

final class HttpProbeNotifier {
    HttpProbeNotifier() {
    }

    static void notifyDataReceived(HttpCodecFilter httpFilter, Connection connection, Buffer buffer) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onDataReceivedEvent(connection, buffer);
                ++n2;
            }
        }
    }

    static void notifyDataSent(HttpCodecFilter httpFilter, Connection connection, Buffer buffer) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onDataSentEvent(connection, buffer);
                ++n2;
            }
        }
    }

    static void notifyHeaderParse(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, int size) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onHeaderParseEvent(connection, header, size);
                ++n2;
            }
        }
    }

    static void notifyHeaderSerialize(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onHeaderSerializeEvent(connection, header, buffer);
                ++n2;
            }
        }
    }

    static void notifyContentChunkParse(HttpCodecFilter httpFilter, Connection connection, HttpContent content) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onContentChunkParseEvent(connection, content);
                ++n2;
            }
        }
    }

    static void notifyContentChunkSerialize(HttpCodecFilter httpFilter, Connection connection, HttpContent content) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onContentChunkSerializeEvent(connection, content);
                ++n2;
            }
        }
    }

    static void notifyContentEncodingParse(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onContentEncodingParseEvent(connection, header, buffer, contentEncoding);
                ++n2;
            }
        }
    }

    static void notifyContentEncodingSerialize(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onContentEncodingSerializeEvent(connection, header, buffer, contentEncoding);
                ++n2;
            }
        }
    }

    static void notifyTransferEncodingParse(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onTransferEncodingParseEvent(connection, header, buffer, transferEncoding);
                ++n2;
            }
        }
    }

    static void notifyTransferEncodingSerialize(HttpCodecFilter httpFilter, Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onTransferEncodingSerializeEvent(connection, header, buffer, transferEncoding);
                ++n2;
            }
        }
    }

    static void notifyProbesError(HttpCodecFilter httpFilter, Connection connection, HttpPacket httpPacket, Throwable error) {
        HttpProbe[] probes = (HttpProbe[])httpFilter.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            if (error == null) {
                error = new IllegalStateException("Error in HTTP semantics");
            }
            HttpProbe[] httpProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                HttpProbe probe = httpProbeArray[n2];
                probe.onErrorEvent(connection, httpPacket, error);
                ++n2;
            }
        }
    }
}

