/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpBrokenContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.memory.Buffers;

public class HttpContent
extends HttpPacket
implements Appendable<HttpContent> {
    private static final ThreadCache.CachedTypeIndex<HttpContent> CACHE_IDX = ThreadCache.obtainIndex(HttpContent.class, (int)16);
    private static final ThreadCache.CachedTypeIndex<Builder> BUILDER_CACHE_IDX = ThreadCache.obtainIndex(Builder.class, (int)16);
    protected boolean isLast;
    protected Buffer content = Buffers.EMPTY_BUFFER;
    protected HttpHeader httpHeader;

    public static boolean isContent(HttpPacket httpPacket) {
        return httpPacket instanceof HttpContent;
    }

    public static boolean isBroken(HttpContent httpContent) {
        return httpContent instanceof HttpBrokenContent;
    }

    public static HttpContent create() {
        return HttpContent.create(null);
    }

    public static HttpContent create(HttpHeader httpHeader) {
        HttpContent httpContent = (HttpContent)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpContent != null) {
            httpContent.httpHeader = httpHeader;
            return httpContent;
        }
        return new HttpContent(httpHeader);
    }

    private static Builder createBuilder(HttpHeader httpHeader) {
        Builder builder = (Builder)ThreadCache.takeFromCache(BUILDER_CACHE_IDX);
        if (builder != null) {
            builder.packet = HttpContent.create(httpHeader);
            return builder;
        }
        return new Builder(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return HttpContent.createBuilder(httpHeader);
    }

    protected HttpContent() {
        this(null);
    }

    protected HttpContent(HttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }

    public Buffer getContent() {
        return this.content;
    }

    protected final void setContent(Buffer content) {
        this.content = content;
    }

    public final HttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    @Override
    public final boolean isHeader() {
        return false;
    }

    public HttpContent append(HttpContent element) {
        if (this.isLast) {
            throw new IllegalStateException("Can not append to a last chunk");
        }
        if (HttpContent.isBroken(element)) {
            return element;
        }
        Buffer content2 = element.getContent();
        if (content2 != null && content2.hasRemaining()) {
            this.content = Buffers.appendBuffers(null, (Buffer)this.content, (Buffer)content2);
        }
        if (element.isLast()) {
            element.setContent(this.content);
            return element;
        }
        return this;
    }

    protected void reset() {
        this.isLast = false;
        this.content = Buffers.EMPTY_BUFFER;
        this.httpHeader = null;
    }

    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static class Builder<T extends Builder> {
        protected HttpContent packet;

        protected Builder() {
        }

        protected Builder(HttpHeader httpHeader) {
            this.packet = HttpContent.create(httpHeader);
        }

        public final T last(boolean isLast) {
            this.packet.setLast(isLast);
            return (T)this;
        }

        public final T content(Buffer content) {
            this.packet.setContent(content);
            return (T)this;
        }

        public HttpContent build() {
            try {
                HttpContent httpContent = this.packet;
                return httpContent;
            }
            finally {
                ThreadCache.putToCache((ThreadCache.CachedTypeIndex)BUILDER_CACHE_IDX, (Object)this);
            }
        }
    }
}

