/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpBrokenContentException;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;

public class HttpBrokenContent
extends HttpContent {
    private static final ThreadCache.CachedTypeIndex<HttpBrokenContent> CACHE_IDX = ThreadCache.obtainIndex(HttpBrokenContent.class, (int)1);
    private static final ThreadCache.CachedTypeIndex<Builder> BUILDER_CACHE_IDX = ThreadCache.obtainIndex(Builder.class, (int)16);
    private HttpBrokenContentException exception;

    public static HttpBrokenContent create() {
        return HttpBrokenContent.create(null);
    }

    public static HttpBrokenContent create(HttpHeader httpHeader) {
        HttpBrokenContent httpBrokenContent = (HttpBrokenContent)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpBrokenContent != null) {
            httpBrokenContent.httpHeader = httpHeader;
            return httpBrokenContent;
        }
        return new HttpBrokenContent(httpHeader);
    }

    private static Builder createBuilder(HttpHeader httpHeader) {
        Builder builder = (Builder)ThreadCache.takeFromCache(BUILDER_CACHE_IDX);
        if (builder != null) {
            builder.packet = HttpBrokenContent.create(httpHeader);
            return builder;
        }
        return new Builder(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return HttpBrokenContent.createBuilder(httpHeader);
    }

    protected HttpBrokenContent(HttpHeader httpHeader) {
        super(httpHeader);
    }

    public HttpBrokenContentException getException() {
        return this.exception;
    }

    @Override
    public Buffer getContent() {
        throw this.exception;
    }

    @Override
    public final boolean isLast() {
        return true;
    }

    @Override
    protected void reset() {
        this.exception = null;
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static /* bridge */ /* synthetic */ HttpContent.Builder builder(HttpHeader httpHeader) {
        return HttpBrokenContent.builder(httpHeader);
    }

    public static /* bridge */ /* synthetic */ HttpContent create(HttpHeader httpHeader) {
        return HttpBrokenContent.create(httpHeader);
    }

    public static /* bridge */ /* synthetic */ HttpContent create() {
        return HttpBrokenContent.create();
    }

    public static final class Builder
    extends HttpContent.Builder<Builder> {
        protected Builder(HttpHeader httpHeader) {
            this.packet = HttpBrokenContent.create(httpHeader);
        }

        public final Builder error(HttpBrokenContentException exception) {
            ((HttpBrokenContent)this.packet).exception = exception;
            return this;
        }

        public final Builder error(Throwable cause) {
            ((HttpBrokenContent)this.packet).exception = cause instanceof HttpBrokenContentException ? (HttpBrokenContentException)cause : new HttpBrokenContentException(cause);
            return this;
        }

        public final Builder error(String message) {
            ((HttpBrokenContent)this.packet).exception = new HttpBrokenContentException(message);
            return this;
        }

        public final Builder error(String message, Throwable cause) {
            ((HttpBrokenContent)this.packet).exception = new HttpBrokenContentException(message, cause);
            return this;
        }

        @Override
        public final HttpContent build() {
            try {
                HttpBrokenContent brokenPacket = (HttpBrokenContent)this.packet;
                if (brokenPacket.exception == null) {
                    brokenPacket.exception = new HttpBrokenContentException();
                }
                HttpBrokenContent httpBrokenContent = (HttpBrokenContent)this.packet;
                return httpBrokenContent;
            }
            finally {
                ThreadCache.putToCache((ThreadCache.CachedTypeIndex)BUILDER_CACHE_IDX, (Object)this);
            }
        }
    }
}

