/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.http.LazyCookieState;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.Charsets;

public class Cookie
implements Cloneable,
Cacheable {
    protected String name;
    protected String value;
    protected String comment;
    protected String domain;
    protected int maxAge = -1;
    protected String path;
    protected boolean secure;
    protected int version = 0;
    protected boolean isHttpOnly;
    protected LazyCookieState lazyCookieState;
    protected boolean usingLazyCookieState;
    private static final String tspecials = ",; ";

    protected Cookie() {
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public String getComment() {
        if (this.comment == null && this.usingLazyCookieState) {
            String commentStr = this.lazyCookieState.getComment().toString(Charsets.ASCII_CHARSET);
            this.comment = this.version == 1 ? this.unescape(commentStr) : null;
        }
        return this.comment;
    }

    public void setDomain(String pattern) {
        if (pattern != null) {
            this.domain = pattern.toLowerCase();
        }
    }

    public String getDomain() {
        String domainStr;
        if (this.domain == null && this.usingLazyCookieState && (domainStr = this.lazyCookieState.getDomain().toString(Charsets.ASCII_CHARSET)) != null) {
            this.domain = this.unescape(domainStr);
        }
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public String getPath() {
        if (this.path == null && this.usingLazyCookieState) {
            this.path = this.unescape(this.lazyCookieState.getPath().toString(Charsets.ASCII_CHARSET));
        }
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getName() {
        if (this.name == null && this.usingLazyCookieState) {
            this.name = this.lazyCookieState.getName().toString(Charsets.ASCII_CHARSET);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        if (this.value == null && this.usingLazyCookieState) {
            this.value = this.unescape(this.lazyCookieState.getValue().toString(Charsets.ASCII_CHARSET));
        }
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public void setHttpOnly(boolean isHttpOnly) {
        this.isHttpOnly = isHttpOnly;
    }

    public String asServerCookieString() {
        StringBuilder sb = new StringBuilder();
        CookieSerializerUtils.serializeServerCookie(sb, this);
        return sb.toString();
    }

    public Buffer asServerCookieBuffer() {
        return this.asServerCookieBuffer(null);
    }

    public Buffer asServerCookieBuffer(MemoryManager memoryManager) {
        if (memoryManager == null) {
            memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
        }
        Buffer buffer = memoryManager.allocate(4096);
        CookieSerializerUtils.serializeServerCookie(buffer, this);
        buffer.trim();
        return buffer;
    }

    public String asClientCookieString() {
        StringBuilder sb = new StringBuilder();
        CookieSerializerUtils.serializeClientCookies(sb, this);
        return sb.toString();
    }

    public Buffer asClientCookieBuffer() {
        return this.asClientCookieBuffer(null);
    }

    public Buffer asClientCookieBuffer(MemoryManager memoryManager) {
        if (memoryManager == null) {
            memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
        }
        Buffer buffer = memoryManager.allocate(4096);
        CookieSerializerUtils.serializeClientCookies(buffer, this);
        buffer.trim();
        return buffer;
    }

    public LazyCookieState getLazyCookieState() {
        this.usingLazyCookieState = true;
        if (this.lazyCookieState == null) {
            this.lazyCookieState = new LazyCookieState();
        }
        return this.lazyCookieState;
    }

    public String getCookieHeaderName() {
        return Cookie.getCookieHeaderName(this.version);
    }

    public static String getCookieHeaderName(int version) {
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    protected boolean lazyNameEquals(String name) {
        return this.name.equals(name);
    }

    protected String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '\\') {
                buf.append(c);
            } else {
                if (++i >= s.length()) {
                    throw new IllegalArgumentException();
                }
                c = s.charAt(i);
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isToken(String value) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void recycle() {
        this.name = null;
        this.value = null;
        this.comment = null;
        this.domain = null;
        this.maxAge = -1;
        this.path = null;
        this.secure = false;
        this.version = 0;
        this.isHttpOnly = false;
        if (this.usingLazyCookieState) {
            this.usingLazyCookieState = false;
            this.lazyCookieState.recycle();
        }
    }
}

