/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.mapping;

import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.exceptions.USMSQLException;

public interface UIDStorage {
	/**
	 * Deletes all ids saved for the given list of folders (table EAS_UIDMapping and table EAS_IdMapping)
	 * @param folderID
	 */
	void deleteAllInFolders(String... folderID) throws DatabaseAccessException, USMSQLException;

	/**
	 * Deletes all ids saved for folders other than the ones in the given list (table EAS_UIDMapping and table EAS_IdMapping)
	 * @param folderID
	 */
	void retainAllInFolders(String... folderID) throws DatabaseAccessException, USMSQLException;

	/**
	 * Deletes one or more entries in a folder from the db (table EAS_UIDMapping and table EAS_IdMapping)
	 * @param user
	 * @param device
	 * @param folderID
	 * @param longID
	 */
	void delete(String folderID, String... longID) throws DatabaseAccessException, USMSQLException;

	/**
	 * Deletes all but the specified entries in a folder from the db (table EAS_UIDMapping and table EAS_IdMapping)
	 * @param user
	 * @param device
	 * @param folderID
	 * @param longID
	 */
	void retain(String folderID, String... longID) throws DatabaseAccessException, USMSQLException;

	/**
	 * Stores a long and short id combination in the DB. (table EAS_UIDMapping). Note that we do not check for
	 * consistency of long ID for multiple entries with the same short ID in different folders. If a client should
	 * send this different UID, we store it and return it on later calls.
	 * 
	 * @param folderID
	 * @param shortID
	 * @param longID
	 */
	void store(String folderID, int shortID, String longID) throws DatabaseAccessException, USMSQLException;

	/**
	 * Returns the longID associated with the given shortID (table EAS_UIDMapping), if it is already associated
	 * with the specified folder. Although shortIDs are unique for a user, they can occur in multiple folders
	 * (public/private). We have to store them for each folder so that the associated long ID will not be deleted
	 * if only one of the folders is no longer present.
	 * 
	 * @param user
	 * @param device
	 * @param folderID
	 * @param shortID
	 * @return the long id or null if no id is found
	 */
	String get(String folderID, int shortID) throws USMSQLException, DatabaseAccessException;

	/**
	 * Returns the longID associated with the given shortID (table EAS_UIDMapping). Since objects can be
	 * present in multiple folders, but must have a unique UID, we need to be able to check if a UID is
	 * associated with a given short ID in any folder.
	 * 
	 * @param user
	 * @param device
	 * @param shortID
	 * @return the long id or null if no id is found
	 */
	String get(int shortID) throws USMSQLException, DatabaseAccessException;
}
