/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.geo;

import java.util.Iterator;
import twitter4j.GeoLocation;
import twitter4j.Place;
import twitter4j.SimilarPlaces;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public final class GetSimilarPlaces {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java twitter4j.examples.geo.GetSimilarPlaces [latitude] [longitude] [name] [place id]");
            System.exit(-1);
        }
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            GeoLocation location = new GeoLocation(Double.parseDouble(args[0]), Double.parseDouble(args[1]));
            String name = args[2];
            String containedWithin = null;
            if (args.length >= 4) {
                containedWithin = args[3];
            }
            SimilarPlaces places = twitter.getSimilarPlaces(location, name, containedWithin, null);
            System.out.println("token: " + places.getToken());
            if (places.size() == 0) {
                System.out.println("No location associated with the specified condition");
            } else {
                Iterator i$ = places.iterator();
                while (i$.hasNext()) {
                    Place place = (Place)i$.next();
                    System.out.println("id: " + place.getId() + " name: " + place.getFullName() + " name: " + place.getFullName());
                    Place[] containedWithinArray = place.getContainedWithIn();
                    if (null == containedWithinArray || containedWithinArray.length == 0) continue;
                    System.out.println("  contained within:");
                    Place[] arr$ = containedWithinArray;
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$; ++i$2) {
                        Place containedWithinPlace = arr$[i$2];
                        System.out.println("  id: " + containedWithinPlace.getId() + " name: " + containedWithinPlace.getFullName());
                    }
                }
            }
            System.exit(0);
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to find similar places: " + te.getMessage());
            System.exit(-1);
        }
    }
}

