Name:           open-xchange-appsuite
Version:        7.0.0
%define         ox_release 8
Release:        %{ox_release}
Group:          Applications/Productivity
Vendor:         Open-Xchange
URL:            http://open-xchange.com
Packager:       Viktor Pracht <viktor.pracht@open-xchange.com>
License:        CC-BY-NC-SA
Summary:        OX App Suite HTML5 client
Source:         %{name}_%{version}.orig.tar.bz2
Requires:       open-xchange-appsuite-l10n-en-us

BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-%{version}-root
BuildRequires:  nodejs >= 0.4.0

%if 0%{?suse_version}
Requires:       apache2
%endif
%if 0%{?fedora_version} || 0%{?rhel_version}
Requires:       httpd
%endif

%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html/appsuite
%else
%define docroot /srv/www/htdocs/appsuite
%endif

%description
OX App Suite HTML5 client

%package        manifest
Group:          Applications/Productivity
Summary:        Manifest for apps included in the OX App Suite HTML5 client
Requires:       open-xchange-core

%description    manifest
OX App Suite HTML5 client

This package contains the manifest for installation on the backend.

%package        dev
Group:          Development/Libraries
Summary:        SDK for the OX App Suite HTML5 client
Requires:       nodejs >= 0.4.0

%description    dev
SDK for the OX App Suite HTML5 client

%package l10n-es-es
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (es_ES)
Provides: open-xchange-appsuite-l10n

%description l10n-es-es
Translation of the OX App Suite HTML5 client (es_ES)

%package l10n-en-us
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (en_US)
Provides: open-xchange-appsuite-l10n

%description l10n-en-us
Translation of the OX App Suite HTML5 client (en_US)

%package l10n-pl-pl
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (pl_PL)
Provides: open-xchange-appsuite-l10n

%description l10n-pl-pl
Translation of the OX App Suite HTML5 client (pl_PL)

%package l10n-fr-fr
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (fr_FR)
Provides: open-xchange-appsuite-l10n

%description l10n-fr-fr
Translation of the OX App Suite HTML5 client (fr_FR)

%package l10n-zh-cn
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (zh_CN)
Provides: open-xchange-appsuite-l10n

%description l10n-zh-cn
Translation of the OX App Suite HTML5 client (zh_CN)

%package l10n-hu-hu
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (hu_HU)
Provides: open-xchange-appsuite-l10n

%description l10n-hu-hu
Translation of the OX App Suite HTML5 client (hu_HU)

%package l10n-zh-tw
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (zh_TW)
Provides: open-xchange-appsuite-l10n

%description l10n-zh-tw
Translation of the OX App Suite HTML5 client (zh_TW)

%package l10n-sk-sk
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (sk_SK)
Provides: open-xchange-appsuite-l10n

%description l10n-sk-sk
Translation of the OX App Suite HTML5 client (sk_SK)

%package l10n-lv-lv
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (lv_LV)
Provides: open-xchange-appsuite-l10n

%description l10n-lv-lv
Translation of the OX App Suite HTML5 client (lv_LV)

%package l10n-ja-jp
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (ja_JP)
Provides: open-xchange-appsuite-l10n

%description l10n-ja-jp
Translation of the OX App Suite HTML5 client (ja_JP)

%package l10n-es-mx
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (es_MX)
Provides: open-xchange-appsuite-l10n

%description l10n-es-mx
Translation of the OX App Suite HTML5 client (es_MX)

%package l10n-cs-cz
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (cs_CZ)
Provides: open-xchange-appsuite-l10n

%description l10n-cs-cz
Translation of the OX App Suite HTML5 client (cs_CZ)

%package l10n-it-it
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (it_IT)
Provides: open-xchange-appsuite-l10n

%description l10n-it-it
Translation of the OX App Suite HTML5 client (it_IT)

%package l10n-nl-nl
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (nl_NL)
Provides: open-xchange-appsuite-l10n

%description l10n-nl-nl
Translation of the OX App Suite HTML5 client (nl_NL)

%package l10n-de-de
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (de_DE)
Provides: open-xchange-appsuite-l10n

%description l10n-de-de
Translation of the OX App Suite HTML5 client (de_DE)

%package l10n-ro-ro
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (ro_RO)
Provides: open-xchange-appsuite-l10n

%description l10n-ro-ro
Translation of the OX App Suite HTML5 client (ro_RO)

%package l10n-fr-ca
Group: Applications/Productivity
Summary: Translation of the OX App Suite HTML5 client (fr_CA)
Provides: open-xchange-appsuite-l10n

%description l10n-fr-ca
Translation of the OX App Suite HTML5 client (fr_CA)


%prep
%setup -q

%build

%install
sh build.sh builddir="%{buildroot}%{docroot}" l10nDir=tmp/l10n \
    manifestDir="%{buildroot}/opt/open-xchange/appsuite" \
    version=%{version} revision=%{release}

find "%{buildroot}%{docroot}" -type d \
    | sed -e 's,%{buildroot},%dir ,' > tmp/files
find "%{buildroot}%{docroot}" \( -type f -o -type l \) \
    | sed -e 's,%{buildroot},,' >> tmp/files
find tmp/l10n \( -type f -o -type l \) -name '*.es_ES.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-es-es

find tmp/l10n \( -type f -o -type l \) -name '*.en_US.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-en-us

find tmp/l10n \( -type f -o -type l \) -name '*.pl_PL.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-pl-pl

find tmp/l10n \( -type f -o -type l \) -name '*.fr_FR.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-fr-fr

find tmp/l10n \( -type f -o -type l \) -name '*.zh_CN.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-zh-cn

find tmp/l10n \( -type f -o -type l \) -name '*.hu_HU.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-hu-hu

find tmp/l10n \( -type f -o -type l \) -name '*.zh_TW.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-zh-tw

find tmp/l10n \( -type f -o -type l \) -name '*.sk_SK.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-sk-sk

find tmp/l10n \( -type f -o -type l \) -name '*.lv_LV.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-lv-lv

find tmp/l10n \( -type f -o -type l \) -name '*.ja_JP.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-ja-jp

find tmp/l10n \( -type f -o -type l \) -name '*.es_MX.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-es-mx

find tmp/l10n \( -type f -o -type l \) -name '*.cs_CZ.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-cs-cz

find tmp/l10n \( -type f -o -type l \) -name '*.it_IT.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-it-it

find tmp/l10n \( -type f -o -type l \) -name '*.nl_NL.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-nl-nl

find tmp/l10n \( -type f -o -type l \) -name '*.de_DE.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-de-de

find tmp/l10n \( -type f -o -type l \) -name '*.ro_RO.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-ro-ro

find tmp/l10n \( -type f -o -type l \) -name '*.fr_CA.js' \
    | sed -e 's,tmp/l10n,%{docroot},' > tmp/files-fr-ca

cp -r tmp/l10n/apps "%{buildroot}%{docroot}/"

mkdir -p "%{buildroot}/opt/open-xchange-appsuite-dev"
cp -r bin lib Jakefile.js "%{buildroot}/opt/open-xchange-appsuite-dev/"
sed -i -e 's#OX_APPSUITE_DEV=.*#OX_APPSUITE_DEV="/opt/open-xchange-appsuite-dev"#' \
    "%{buildroot}/opt/open-xchange-appsuite-dev/bin/build-appsuite"

%clean
sh build.sh clean builddir="%{buildroot}%{docroot}" version=%{version} revision=%{release}
rm -r "%{buildroot}/opt/open-xchange/appsuite"
rm -r "%{buildroot}/opt/open-xchange-appsuite-dev"

%files -f tmp/files
%defattr(-,root,root)
%doc readme.txt

%files manifest
%defattr(-,root,root)
%dir /opt/open-xchange
/opt/open-xchange/appsuite

%files dev
%defattr(-,root,root)
%dir /opt/open-xchange-appsuite-dev
/opt/open-xchange-appsuite-dev
%attr(644,root,root) /opt/open-xchange-appsuite-dev/lib/sax-js/examples/switch-bench.js

%files l10n-es-es -f tmp/files-es-es
%defattr(-,root,root)

%files l10n-en-us -f tmp/files-en-us
%defattr(-,root,root)

%files l10n-pl-pl -f tmp/files-pl-pl
%defattr(-,root,root)

%files l10n-fr-fr -f tmp/files-fr-fr
%defattr(-,root,root)

%files l10n-zh-cn -f tmp/files-zh-cn
%defattr(-,root,root)

%files l10n-hu-hu -f tmp/files-hu-hu
%defattr(-,root,root)

%files l10n-zh-tw -f tmp/files-zh-tw
%defattr(-,root,root)

%files l10n-sk-sk -f tmp/files-sk-sk
%defattr(-,root,root)

%files l10n-lv-lv -f tmp/files-lv-lv
%defattr(-,root,root)

%files l10n-ja-jp -f tmp/files-ja-jp
%defattr(-,root,root)

%files l10n-es-mx -f tmp/files-es-mx
%defattr(-,root,root)

%files l10n-cs-cz -f tmp/files-cs-cz
%defattr(-,root,root)

%files l10n-it-it -f tmp/files-it-it
%defattr(-,root,root)

%files l10n-nl-nl -f tmp/files-nl-nl
%defattr(-,root,root)

%files l10n-de-de -f tmp/files-de-de
%defattr(-,root,root)

%files l10n-ro-ro -f tmp/files-ro-ro
%defattr(-,root,root)

%files l10n-fr-ca -f tmp/files-fr-ca
%defattr(-,root,root)


%changelog
* Thu Nov 10 2011 viktor.pracht@open-xchange.com
  - Initial release
