/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;



import static com.openexchange.util.custom.base.NullUtil.emptySet;
import com.google.common.collect.ImmutableSet;
import com.openexchange.annotation.Nullable;
import com.openexchange.util.activator.ServiceDependencyResolver;


/**
 * {@link ServiceInstanceServiceWithDependencies}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.2
 */
public class ServiceInstanceServiceWithDependencies<S, T extends S> extends ServiceWithDependenciesTemplate<S, T> {

    protected final T serviceInstance;
    
    @SuppressWarnings("unchecked")
    public ServiceInstanceServiceWithDependencies(final T serviceInstance, final @Nullable Class<S> optServiceClass,
        final @Nullable ImmutableSet<MandatoryServiceDependency<?>> mandatoryDependencies,
        final @Nullable ImmutableSet<OptionalServiceDependency<?>> optionalDependencies) {
        super(
            (Class<T>) serviceInstance.getClass(),
            optServiceClass,
            mandatoryDependencies != null ? mandatoryDependencies : emptySet(),
            optionalDependencies != null ? optionalDependencies : emptySet(),
            emptySet(),
            emptySet()
        );
        this.serviceInstance = serviceInstance;
    }

    @Override
    public T createInstance(ServiceDependencyResolver resolver) {
        return serviceInstance;
    }

}
